package examples;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.CellRenderer;
import jp.sf.beanbinder.annotations.AlignType;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Basic;
import jp.sf.beanbinder.annotations.Column;
import jp.sf.beanbinder.annotations.IMEMode;
import jp.sf.beanbinder.annotations.Table;
import model.Employee;

public class TableExample extends JFrame {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    
    @Table( objectKey="empList",
            columns={
                @Column( prop="code", text="コード" ),
                @Column( prop="name", text="氏名", imeMode=IMEMode.JP ),
                @Column( prop="age", text="年齢" ),
                @Column( prop="sex", text="性別", cellRendererField="cellRenderer1"),
                @Column( prop="address.postcode", text="郵便番号" )
            }
    )
    private JTable tbl;
    
    @Basic(objectKey="bean", prop="", horizon=AlignType.CENTER)
    private JLabel lbl = new JLabel();
    private CellRenderer cellRenderer1 = new CellRenderer(this.binder, lbl){
        public void update(BeanBinder binder, BindProperty property, Object displayValue, Object value, int row, int column) {
            binder.setObject("bean", (value.equals(true)?"男性":"女性"));
            binder.updateComponent("lbl");
        }
    };
    
    public TableExample() {
        this.setTitle("TableBox");
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setSize(640, 480);
        this.setLayout(new BorderLayout());
    
        //コンポーネントの配置
        this.tbl = new JTable();
        this.add(new JScrollPane(tbl), BorderLayout.CENTER);
        
        //サンプルオブジェクト
        List<Employee> employeeList = new ArrayList<Employee>();
        Employee employee = new Employee();
        employee.setCode("A0001");
        employee.setName("山田 太郎");
        employee.setAge(30);
        employee.setSex(true);
        employee.getAddress().setPostcode("000-0000");
        employeeList.add(employee);
        
        employee = new Employee();
        employee.setCode("A0002");
        employee.setName("吉田 花子");
        employee.setAge(25);
        employee.getAddress().setPostcode("123-4567");
        employeeList.add(employee);
        this.binder.setObject("empList", employeeList);
        
        //アノテーションからマッピング
        new AnnotationParser(this.binder, this).parse();
        
        //画面の再描画
        this.binder.updateComponent(".*");
    }
    public static void main(String[] args) {
        new TableExample().setVisible(true);
    }
}