package examples;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Basic;
import jp.sf.beanbinder.annotations.IMEMode;
import jp.sf.beanbinder.exception.ValidateException;
import model.Employee;

public class TextBoxExample extends JFrame implements ActionListener {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    
    @Basic( objectKey="emp", prop="name", imeMode=IMEMode.JP )
    private JTextField textBox;
    
    public TextBoxExample() {
        this.setTitle("TextBoxのサンプル");
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setSize(640, 480);
        this.setLayout(null);
    
        //コンポーネントの配置
        this.textBox = new JTextField();
        this.textBox.setBounds(10, 10, 240, 20);
        this.add(this.textBox);
        
        //サンプルオブジェクト
        Employee employee = new Employee();
        employee.setName("山田 太郎");
        this.binder.setObject("emp", employee);
        
        //アノテーションからマッピング
        new AnnotationParser(this.binder, this).parse();
        
        //リスナーの追加
        this.textBox.addActionListener(this);
        
        //画面の再描画
        this.binder.updateComponent(".*");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            //オブジェクトの更新
            this.binder.updateObject("emp");
            
            //オブジェクトの取得
            Employee employee = (Employee)this.binder.getObject("emp");
            
            //更新後の結果を表示
            JOptionPane.showMessageDialog(this,
                    "氏名:"+employee.getName(),
                    "オブジェクトは更新されました",
                    JOptionPane.INFORMATION_MESSAGE );
        }catch(ValidateException ex) {
            ex.printStackTrace();
        }
    }
    public static void main(String[] args) {
        new TextBoxExample().setVisible(true);
    }
}
