package model;

import java.math.BigDecimal;

public class ItemDetail {
    private Long id;
    private Product product;    //商品
    private BigDecimal qty;     //数量
    
    public ItemDetail() {}
    public ItemDetail(Product product, BigDecimal qty) {
        this.product = product;
        this.qty = qty;
    }
    
    public BigDecimal getTotalPrice() {
        return product.getUnitPrice().multiply(this.getQty());
    }
    
    public Long getId() {
        return id;
    }
    public void setId(Long id) {
        this.id = id;
    }
    public Product getProduct() {
        return product;
    }
    public void setProduct(Product product) {
        this.product = product;
    }
    public BigDecimal getQty() {
        return qty;
    }
    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }
}
