package model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Order {
    private Long id;
    private String code;        //受注コード
    private Date orderedDate;   //受注日
    private Employee employee;  //担当者
    private List<ItemDetail> itemDetails = new ArrayList<ItemDetail>(); //明細行
    private BigDecimal taxRate = new BigDecimal(0.05);  //税率

    public BigDecimal getTotalPrice() {
        BigDecimal totalPrice = new BigDecimal(0);
        for(ItemDetail itemDetail : this.getItemDetails()) {
            totalPrice = totalPrice.add(itemDetail.getTotalPrice());
        }
        return totalPrice;
    }
    public BigDecimal getTax() {
        return this.getTotalPrice().multiply(this.getTaxRate()).setScale(0, BigDecimal.ROUND_DOWN);
    }
    public BigDecimal getGross() {
        return this.getTotalPrice().add(this.getTax());
    }
    public void addItemDetail(Product product, BigDecimal qty) {
        this.itemDetails.add(new ItemDetail(product, qty));
    }
    
    public Employee getEmployee() {
        return employee;
    }
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }
    public List<ItemDetail> getItemDetails() {
        return itemDetails;
    }
    public void setItemDetails(List<ItemDetail> itemDetails) {
        this.itemDetails = itemDetails;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getCode() {
        return code;
    }
    public void setCode(String code) {
        this.code = code;
    }
    public Long getId() {
        return id;
    }
    public void setId(Long id) {
        this.id = id;
    }
    public Date getOrderedDate() {
        return orderedDate;
    }
    public void setOrderedDate(Date orderedDate) {
        this.orderedDate = orderedDate;
    }
    
}
