/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.hbmlint.Analyzer;
import org.hibernate.tool.hbmlint.AnalyzerProblem;

public class ConfigurationAnalyzer {
    final Analyzer[] analyzers;
    List results = new ArrayList();

    public ConfigurationAnalyzer(Analyzer[] analyzers) {
        this.analyzers = analyzers;
    }

    public void analyze(Configuration cfg) {
        Settings settings = cfg.buildSettings();
        for (int i = 0; i < this.analyzers.length; ++i) {
            this.analyzers[i].initialize(cfg, settings);
        }
        Iterator iter = cfg.getClassMappings();
        while (iter.hasNext()) {
            AnalyzerProblem analyze;
            Analyzer analyzer;
            int i;
            PersistentClass clazz = (PersistentClass)iter.next();
            for (i = 0; i < this.analyzers.length; ++i) {
                analyzer = this.analyzers[i];
                analyze = analyzer.analyze(cfg, clazz);
                if (analyze == null) continue;
                this.reportProblem(analyze);
            }
            if (clazz.hasIdentifierProperty()) {
                for (i = 0; i < this.analyzers.length; ++i) {
                    analyzer = this.analyzers[i];
                    analyze = analyzer.analyze(cfg, clazz.getIdentifierProperty());
                    if (analyze == null) continue;
                    this.reportProblem(analyze);
                }
            }
            Iterator propertyIterator = clazz.getPropertyIterator();
            while (propertyIterator.hasNext()) {
                Property property = (Property)propertyIterator.next();
                for (int i2 = 0; i2 < this.analyzers.length; ++i2) {
                    Analyzer analyzer2 = this.analyzers[i2];
                    AnalyzerProblem analyze2 = analyzer2.analyze(cfg, property);
                    if (analyze2 == null) continue;
                    this.reportProblem(analyze2);
                }
            }
        }
    }

    private void reportProblem(AnalyzerProblem analyze) {
        this.results.add(analyze);
    }

    public List getResults() {
        return this.results;
    }
}

