/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.Store;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiskStore
implements Store {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$store$DiskStore == null ? (class$net$sf$ehcache$store$DiskStore = DiskStore.class$("net.sf.ehcache.store.DiskStore")) : class$net$sf$ehcache$store$DiskStore).getName());
    private static final int MS_PER_SECOND = 1000;
    private static final int SPOOL_THREAD_INTERVAL = 200;
    private long expiryThreadInterval;
    private final String name;
    private boolean active;
    private RandomAccessFile randomAccessFile;
    private Map diskElements = Collections.synchronizedMap(new HashMap());
    private List freeSpace = Collections.synchronizedList(new ArrayList());
    private final Map spool = Collections.synchronizedMap(new HashMap());
    private Thread spoolThread;
    private Thread expiryThread;
    private Cache cache;
    private final boolean persistent;
    private final String diskPath;
    private File dataFile;
    private File indexFile;
    private Status status = Status.STATUS_UNINITIALISED;
    private long totalSize;
    static /* synthetic */ Class class$net$sf$ehcache$store$DiskStore;

    public DiskStore(Cache cache, String diskPath) {
        this.cache = cache;
        this.name = cache.getName();
        this.diskPath = diskPath;
        this.expiryThreadInterval = cache.getDiskExpiryThreadIntervalSeconds();
        this.persistent = cache.isDiskPersistent();
        try {
            this.initialiseFiles();
            this.active = true;
            this.spoolThread = new SpoolThread();
            this.spoolThread.start();
            if (!cache.isEternal()) {
                this.expiryThread = new ExpiryThread();
                this.expiryThread.start();
            }
            this.status = Status.STATUS_ALIVE;
        }
        catch (Exception e) {
            this.dispose();
            LOG.error((Object)(this.name + "Cache: Could not create disk store. Initial cause was " + e.getMessage()), (Throwable)e);
        }
    }

    private void initialiseFiles() throws Exception {
        File diskDir = new File(this.diskPath);
        if (diskDir.exists() && !diskDir.isDirectory()) {
            throw new Exception("Store directory \"" + diskDir.getCanonicalPath() + "\" exists and is not a directory.");
        }
        if (!diskDir.exists() && !diskDir.mkdirs()) {
            throw new Exception("Could not create cache directory \"" + diskDir.getCanonicalPath() + "\".");
        }
        this.dataFile = new File(diskDir, this.getDataFileName());
        this.indexFile = new File(diskDir, this.getIndexFileName());
        this.deleteIndexIfNoData();
        if (this.persistent) {
            if (!this.readIndex()) {
                LOG.debug((Object)("Index file dirty or empty. Deleting data file " + this.getDataFileName()));
                this.dataFile.delete();
            }
        } else {
            LOG.debug((Object)("Deleting data file " + this.getDataFileName()));
            this.dataFile.delete();
            this.indexFile = null;
        }
        this.randomAccessFile = new RandomAccessFile(this.dataFile, "rw");
    }

    private void deleteIndexIfNoData() {
        boolean dataFileExists = this.dataFile.exists();
        boolean indexFileExists = this.indexFile.exists();
        if (!dataFileExists && indexFileExists) {
            LOG.debug((Object)("Matching data file missing for index file. Deleting index file " + this.getIndexFileName()));
            this.indexFile.delete();
        }
    }

    private void checkActive() throws CacheException {
        if (!this.active) {
            throw new CacheException(this.name + " Cache: The Disk store is not active.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Element get(Object key) {
        try {
            Element element;
            this.checkActive();
            Map map = this.spool;
            synchronized (map) {
                element = (Element)this.spool.remove(key);
            }
            if (element != null) {
                element.updateAccessStatistics();
                return element;
            }
            DiskElement diskElement = (DiskElement)this.diskElements.get(key);
            if (diskElement == null) {
                return null;
            }
            element = this.loadElementFromDiskElement(diskElement);
            element.updateAccessStatistics();
            return element;
        }
        catch (Exception exception) {
            LOG.error((Object)(this.name + "Cache: Could not read disk store element for key " + key + ". Error was " + exception.getMessage()), (Throwable)exception);
            return null;
        }
    }

    public final boolean containsKey(Object key) {
        return this.diskElements.containsKey(key) || this.spool.containsKey(key);
    }

    private Element loadElementFromDiskElement(DiskElement diskElement) throws IOException, ClassNotFoundException {
        this.randomAccessFile.seek(diskElement.position);
        byte[] buffer = new byte[diskElement.payloadSize];
        this.randomAccessFile.readFully(buffer);
        ByteArrayInputStream instr = new ByteArrayInputStream(buffer);
        ObjectInputStream objstr = new ObjectInputStream(instr){

            protected Class resolveClass(ObjectStreamClass clazz) throws ClassNotFoundException {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return Class.forName(clazz.getName(), false, classLoader);
            }
        };
        Element element = (Element)objstr.readObject();
        objstr.close();
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Element getQuiet(Object key) {
        try {
            Element element;
            this.checkActive();
            Map map = this.spool;
            synchronized (map) {
                element = (Element)this.spool.remove(key);
            }
            if (element != null) {
                return element;
            }
            DiskElement diskElement = (DiskElement)this.diskElements.get(key);
            if (diskElement == null) {
                return null;
            }
            element = this.loadElementFromDiskElement(diskElement);
            return element;
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + "Cache: Could not read disk store element for key " + key + ". Initial cause was " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object[] getKeyArray() {
        Set spoolKeySet;
        Set elementKeySet;
        Map map = this.diskElements;
        synchronized (map) {
            elementKeySet = this.diskElements.keySet();
        }
        Map map2 = this.spool;
        synchronized (map2) {
            spoolKeySet = this.spool.keySet();
        }
        HashSet allKeysSet = new HashSet(elementKeySet.size() + spoolKeySet.size());
        allKeysSet.addAll(elementKeySet);
        allKeysSet.addAll(spoolKeySet);
        return allKeysSet.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int getSize() {
        try {
            int diskSize;
            int spoolSize;
            this.checkActive();
            Map map = this.spool;
            synchronized (map) {
                spoolSize = this.spool.size();
            }
            Map map2 = this.diskElements;
            synchronized (map2) {
                diskSize = this.diskElements.size();
            }
            return spoolSize + diskSize;
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + "Cache: Could not determine size of disk store.. Initial cause was " + e.getMessage()), (Throwable)e);
            return 0;
        }
    }

    public final Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Element element) {
        block9: {
            try {
                this.checkActive();
                if (this.spoolThread.isAlive()) {
                    Map map = this.spool;
                    synchronized (map) {
                        this.spool.put(element.getObjectKey(), element);
                        break block9;
                    }
                }
                LOG.error((Object)(this.name + "Cache: Elements cannot be written to disk store because the" + " spool thread has died."));
                Map map = this.spool;
                synchronized (map) {
                    this.spool.clear();
                }
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + "Cache: Could not write disk store element for " + element.getObjectKey() + ". Initial cause was " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Element remove(Object key) {
        Element element;
        try {
            this.checkActive();
            Map map = this.spool;
            synchronized (map) {
                element = (Element)this.spool.remove(key);
            }
            map = this.diskElements;
            synchronized (map) {
                DiskElement diskElement = (DiskElement)this.diskElements.remove(key);
                if (diskElement != null) {
                    element = this.loadElementFromDiskElement(diskElement);
                    this.freeBlock(diskElement);
                }
            }
        }
        catch (Exception exception) {
            String message = this.name + "Cache: Could not remove disk store entry for " + key + ". Error was " + exception.getMessage();
            LOG.error((Object)message, (Throwable)exception);
            throw new CacheException(message);
        }
        return element;
    }

    private void freeBlock(DiskElement element) {
        this.totalSize -= (long)element.payloadSize;
        element.payloadSize = 0;
        this.freeSpace.add(element);
    }

    public final synchronized void removeAll() {
        try {
            this.checkActive();
            this.notifyingRemoveAll();
            this.spool.clear();
            this.diskElements.clear();
            this.freeSpace.clear();
            this.totalSize = 0L;
            this.randomAccessFile.setLength(0L);
            if (this.persistent) {
                this.indexFile.delete();
                this.indexFile.createNewFile();
            }
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + " Cache: Could not rebuild disk store. Initial cause was " + e.getMessage()), (Throwable)e);
            this.dispose();
        }
    }

    private void notifyingRemoveAll() {
        RegisteredEventListeners listeners = this.cache.getCacheEventNotificationService();
        if (!listeners.getCacheEventListeners().isEmpty()) {
            Object[] keys = this.getKeyArray();
            for (int i = 0; i < keys.length; ++i) {
                Serializable key = (Serializable)keys[i];
                Element element = this.remove(key);
                if (this.cache.isExpired(element)) {
                    listeners.notifyElementExpiry(element, false);
                    continue;
                }
                listeners.notifyElementRemoved(element, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        if (!this.active) {
            return;
        }
        try {
            if (this.expiryThread != null) {
                this.expiryThread.interrupt();
            }
            this.flush();
            this.spool.clear();
            this.diskElements.clear();
            this.freeSpace.clear();
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
            if (!this.persistent) {
                LOG.debug((Object)("Deleting file " + this.dataFile.getName()));
                this.dataFile.delete();
            }
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + "Cache: Could not shut down disk cache. Initial cause was " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.active = false;
            this.randomAccessFile = null;
            this.notifyAll();
            this.cache = null;
        }
    }

    public final void flush() throws IOException {
        if (this.persistent) {
            this.flushSpool();
            this.writeIndex();
        }
    }

    public final synchronized boolean isSpoolEmpty() {
        return !this.active || this.spool.size() == 0;
    }

    private void spoolThreadMain() {
        while (true) {
            if (this.active && this.spool.size() == 0) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Spool Thread interrupted.");
                    return;
                }
            }
            if (!this.active) {
                return;
            }
            if (this.spool.size() == 0) continue;
            try {
                this.flushSpool();
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)(this.name + "Cache: Could not write elements to disk cache. Initial cause was " + e.getMessage()), (Throwable)e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushSpool() throws IOException {
        Object[] spoolCopy;
        Map map = this.spool;
        synchronized (map) {
            spoolCopy = this.spool.values().toArray();
            this.spool.clear();
        }
        for (int i = 0; i < spoolCopy.length; ++i) {
            byte[] buffer;
            DiskElement oldBlock;
            Element element = (Element)spoolCopy[i];
            if (element == null) continue;
            Serializable key = (Serializable)element.getObjectKey();
            Map map2 = this.diskElements;
            synchronized (map2) {
                oldBlock = (DiskElement)this.diskElements.remove(key);
            }
            if (oldBlock != null) {
                this.freeBlock(oldBlock);
            }
            try {
                ByteArrayOutputStream outstr = new ByteArrayOutputStream();
                ObjectOutputStream objstr = new ObjectOutputStream(outstr);
                objstr.writeObject(element);
                objstr.close();
                buffer = outstr.toByteArray();
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + "Cache: Failed to write element to disk '" + element.getObjectKey() + "'. Initial cause was " + e.getMessage()), (Throwable)e);
                continue;
            }
            DiskElement diskElement = this.findFreeBlock(buffer.length);
            if (diskElement == null) {
                diskElement = new DiskElement();
                diskElement.position = this.randomAccessFile.length();
                diskElement.blockSize = buffer.length;
            }
            this.randomAccessFile.seek(diskElement.position);
            this.randomAccessFile.write(buffer);
            if (this.cache.isEternal()) {
                diskElement.expiryTime = Long.MAX_VALUE;
            } else {
                long timeToLive = element.getCreationTime() + this.cache.getTimeToLiveSeconds() * 1000L;
                long timeToIdle = element.getLastAccessTime() + this.cache.getTimeToIdleSeconds() * 1000L;
                diskElement.expiryTime = Math.max(timeToLive, timeToIdle);
            }
            diskElement.payloadSize = buffer.length;
            this.totalSize += (long)buffer.length;
            Map map3 = this.diskElements;
            synchronized (map3) {
                this.diskElements.put(key, diskElement);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeIndex() throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fout = new FileOutputStream(this.indexFile);
            objectOutputStream = new ObjectOutputStream(fout);
            objectOutputStream.writeObject(this.diskElements);
            objectOutputStream.writeObject(this.freeSpace);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean readIndex() throws IOException {
        ObjectInputStream objectInputStream = null;
        FileInputStream fin = null;
        boolean success = false;
        if (this.indexFile.exists()) {
            try {
                fin = new FileInputStream(this.indexFile);
                objectInputStream = new ObjectInputStream(fin);
                this.diskElements = (Map)objectInputStream.readObject();
                this.freeSpace = (List)objectInputStream.readObject();
                success = true;
            }
            catch (StreamCorruptedException e) {
                LOG.error((Object)"Corrupt index file. Creating new index.");
            }
            catch (IOException e) {
                LOG.debug((Object)"IOException reading index. Creating new index. ");
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Class loading problem reading index. Creating new index. Initial cause was " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    } else if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Problem closing the index file.");
                }
                this.createNewIndexFile();
            }
        } else {
            this.createNewIndexFile();
        }
        return success;
    }

    private void createNewIndexFile() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            LOG.debug((Object)("Index file " + this.indexFile + " deleted."));
        }
        if (!this.indexFile.createNewFile()) {
            throw new IOException("Index file " + this.indexFile + " could not created.");
        }
        LOG.debug((Object)("Index file " + this.indexFile + " created successfully"));
    }

    private void expiryThreadMain() {
        block3: {
            long expiryThreadIntervalMillis = this.expiryThreadInterval * 1000L;
            try {
                while (this.active) {
                    Thread.sleep(expiryThreadIntervalMillis);
                    this.expireElements();
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)(this.name + "Cache: Expiry thread interrupted on Disk Store."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireElements() {
        Iterator<Object> iterator;
        long now = System.currentTimeMillis();
        Map map = this.spool;
        synchronized (map) {
            iterator = this.spool.values().iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!this.cache.isExpired(element)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + "Cache: Removing expired spool element " + element.getObjectKey()));
                }
                iterator.remove();
                this.notifyExpiryListeners(element);
            }
        }
        map = this.diskElements;
        synchronized (map) {
            iterator = this.diskElements.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                DiskElement diskElement = (DiskElement)entry.getValue();
                if (now < diskElement.expiryTime) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + "Cache: Removing expired spool element " + entry.getKey() + " from Disk Store"));
                }
                iterator.remove();
                Element element = null;
                try {
                    element = this.loadElementFromDiskElement(diskElement);
                }
                catch (Exception exception) {
                    LOG.error((Object)(this.name + "Cache: Could not remove disk store entry for " + entry.getKey() + ". Error was " + exception.getMessage()), (Throwable)exception);
                }
                this.freeBlock(diskElement);
                this.notifyExpiryListeners(element);
            }
        }
    }

    private void notifyExpiryListeners(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
    }

    private DiskElement findFreeBlock(int length) {
        for (int i = 0; i < this.freeSpace.size(); ++i) {
            DiskElement element = (DiskElement)this.freeSpace.get(i);
            if (element.blockSize < length) continue;
            this.freeSpace.remove(i);
            return element;
        }
        return null;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ dataFile = ").append(this.dataFile.getAbsolutePath()).append(", active=").append(this.active).append(", totalSize=").append(this.totalSize).append(", status=").append(this.status).append(", expiryThreadInterval = ").append(this.expiryThreadInterval).append(" ]");
        return sb.toString();
    }

    public final long getTotalFileSize() {
        return this.getDataFileSize() + this.getIndexFileSize();
    }

    public final long getDataFileSize() {
        return this.dataFile.length();
    }

    public final float calculateDataFileSparseness() {
        return 1.0f - (float)this.getUsedDataSize() / (float)this.getDataFileSize();
    }

    public final long getUsedDataSize() {
        return this.totalSize;
    }

    public final long getIndexFileSize() {
        if (this.indexFile == null) {
            return 0L;
        }
        return this.indexFile.length();
    }

    public final String getDataFileName() {
        return this.name + ".data";
    }

    public final String getDataFilePath() {
        return this.diskPath;
    }

    public final String getIndexFileName() {
        return this.name + ".index";
    }

    public final boolean isExpiryThreadAlive() {
        if (this.expiryThread == null) {
            return false;
        }
        return this.expiryThread.isAlive();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class ExpiryThread
    extends Thread {
        public ExpiryThread() {
            super("Store " + DiskStore.this.name + " Expiry Thread");
            this.setDaemon(true);
            this.setPriority(1);
        }

        public final void run() {
            DiskStore.this.expiryThreadMain();
        }
    }

    private final class SpoolThread
    extends Thread {
        public SpoolThread() {
            super("Store " + DiskStore.this.name + " Spool Thread");
            this.setDaemon(true);
            this.setPriority(2);
        }

        public final void run() {
            DiskStore.this.spoolThreadMain();
        }
    }

    private static final class DiskElement
    implements Serializable {
        private static final long serialVersionUID = -717310932566592289L;
        private long position;
        private int payloadSize;
        private int blockSize;
        private long expiryTime;

        private DiskElement() {
        }
    }
}

