/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.annotations;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import jp.sf.beanbinder.AlignType;
import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.BindingBridge;
import jp.sf.beanbinder.CellRenderer;
import jp.sf.beanbinder.IMEMode;
import jp.sf.beanbinder.MappingParser;
import jp.sf.beanbinder.annotations.Basic;
import jp.sf.beanbinder.annotations.Column;
import jp.sf.beanbinder.annotations.Custom;
import jp.sf.beanbinder.annotations.Select;
import jp.sf.beanbinder.annotations.Table;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.listener.EditListener;
import jp.sf.beanbinder.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationParser
implements MappingParser {
    private Object target;
    private BindingBridge bridge;
    private BeanBinder binder;

    public AnnotationParser(BeanBinder binder, Object target) {
        this.target = target;
        this.binder = binder;
    }

    public void parse() {
        this.bridge = new BindingBridge(this.binder, this.target);
        ArrayList<Field> results = new ArrayList<Field>();
        this.parseFields(results, this.target.getClass());
        AccessibleObject[] fields = results.toArray(new Field[0]);
        AccessibleObject.setAccessible(fields, true);
        try {
            AccessibleObject[] accessibleObjectArray = fields;
            int n = 0;
            int n2 = accessibleObjectArray.length;
            while (n < n2) {
                AccessibleObject field = accessibleObjectArray[n];
                this.parseAnnotation(this.target, (Field)field);
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void parseFields(List<Field> fields, Class currentClass) {
        Field[] fs;
        if (currentClass == null) {
            return;
        }
        Field[] fieldArray = fs = currentClass.getDeclaredFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field f = fieldArray[n];
            fields.add(f);
            ++n;
        }
        this.parseFields(fields, currentClass.getSuperclass());
    }

    private void parseAnnotation(Object target, Field field) throws Exception {
        Table table;
        Select select;
        Custom custom;
        Basic basic = field.getAnnotation(Basic.class);
        if (basic != null) {
            this.basic(target, field, basic);
        }
        if ((custom = field.getAnnotation(Custom.class)) != null) {
            this.custom(target, field, custom);
        }
        if ((select = field.getAnnotation(Select.class)) != null) {
            this.select(target, field, select);
        }
        if ((table = field.getAnnotation(Table.class)) != null) {
            this.table(target, field, table);
        }
    }

    private IMEMode getIMEMode(jp.sf.beanbinder.annotations.IMEMode imeMode) {
        if (imeMode == null) {
            return IMEMode.DEFAULT;
        }
        if (imeMode.equals((Object)jp.sf.beanbinder.annotations.IMEMode.DEFAULT)) {
            return IMEMode.DEFAULT;
        }
        if (imeMode.equals((Object)jp.sf.beanbinder.annotations.IMEMode.JP)) {
            return IMEMode.JP;
        }
        if (imeMode.equals((Object)jp.sf.beanbinder.annotations.IMEMode.HALFKANA)) {
            return IMEMode.HALFKANA;
        }
        return null;
    }

    private AlignType getHorizon(jp.sf.beanbinder.annotations.AlignType align) {
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.LEFT)) {
            return AlignType.LEFT;
        }
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.RIGHT)) {
            return AlignType.RIGHT;
        }
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.CENTER)) {
            return AlignType.CENTER;
        }
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.TOP)) {
            return AlignType.TOP;
        }
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.BOTTOM)) {
            return AlignType.BOTTOM;
        }
        return AlignType.LEFT;
    }

    private AlignType getVertical(jp.sf.beanbinder.annotations.AlignType align) {
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.LEFT)) {
            return AlignType.LEFT;
        }
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.RIGHT)) {
            return AlignType.RIGHT;
        }
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.CENTER)) {
            return AlignType.CENTER;
        }
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.TOP)) {
            return AlignType.TOP;
        }
        if (align.equals((Object)jp.sf.beanbinder.annotations.AlignType.BOTTOM)) {
            return AlignType.BOTTOM;
        }
        return AlignType.TOP;
    }

    private void table(Object target, Field field, Table table) throws Exception {
        ArrayList<BindProperty> columns = new ArrayList<BindProperty>();
        int i = 0;
        while (i < table.columns().length) {
            Column col = table.columns()[i];
            BindProperty prop = this.bridge.bindColumn(col.displayProp(), col.valueProp(), col.idProp(), col.text(), col.readOnly(), col.prop(), col.width(), this.getIMEMode(col.imeMode()), (Format)this.bridge.getFieldValue(target, col.formatField()), this.getHorizon(col.horizon()), this.getVertical(col.vertical()), (Validator)this.bridge.getFieldValue(target, col.validatorField()), (CellEditor)this.bridge.getFieldValue(target, col.cellEditorField()), (CellRenderer)this.bridge.getFieldValue(target, col.cellRendererField()));
            columns.add(prop);
            ++i;
        }
        this.bridge.bindTable(field.getName(), table.objectKey(), table.group(), table.rowHeight(), table.sortable(), (EditListener)this.bridge.getFieldValue(target, table.editListenerField()), columns.toArray(new BindProperty[0]));
    }

    private void basic(Object target, Field field, Basic basic) throws Exception {
        this.bridge.bindBasic(field.getName(), basic.objectKey(), basic.prop(), basic.group(), this.getIMEMode(basic.imeMode()), (Format)this.bridge.getFieldValue(target, basic.formatField()), this.getHorizon(basic.horizon()), this.getVertical(basic.vertical()), (Validator)this.bridge.getFieldValue(target, basic.validatorField()));
    }

    private void custom(Object target, Field field, Custom custom) throws Exception {
        this.bridge.bindCustom(field.getName(), custom.objectKey(), custom.displayProp(), custom.idProp(), custom.group(), this.getIMEMode(custom.imeMode()), (Format)this.bridge.getFieldValue(target, custom.formatField()), this.getHorizon(custom.horizon()), this.getVertical(custom.vertical()), (Validator)this.bridge.getFieldValue(target, custom.validatorField()));
    }

    private void select(Object target, Field field, Select select) throws Exception {
        this.bridge.bindSelect(field.getName(), select.group(), select.destKey(), select.destValueProp(), select.destIdProp(), select.srcKey(), select.srcDisplayProp(), select.srcValueProp(), select.srcIdProp(), (Format)this.bridge.getFieldValue(target, select.formatField()), this.getHorizon(select.horizon()), this.getVertical(select.vertical()), (Validator)this.bridge.getFieldValue(target, select.validatorField()));
    }
}

