/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.ASTFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.QueryTranslatorImpl;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.util.SyntheticAndFactory;
import org.hibernate.sql.JoinFragment;
import org.hibernate.util.StringHelper;

public class JoinProcessor
implements SqlTokenTypes {
    private static final Log log = LogFactory.getLog((Class)JoinProcessor.class);
    private QueryTranslatorImpl queryTranslatorImpl;
    private SyntheticAndFactory andFactory;

    public JoinProcessor(ASTFactory astFactory, QueryTranslatorImpl queryTranslatorImpl) {
        this.andFactory = new SyntheticAndFactory(astFactory);
        this.queryTranslatorImpl = queryTranslatorImpl;
    }

    public static int toHibernateJoinType(int astJoinType) {
        switch (astJoinType) {
            case 132: {
                return 1;
            }
            case 28: {
                return 0;
            }
            case 133: {
                return 2;
            }
        }
        throw new AssertionFailure("undefined join type " + astJoinType);
    }

    public void processJoins(QueryNode query, boolean inSubquery) {
        final FromClause fromClause = query.getFromClause();
        ArrayList orderedFromElements = new ArrayList();
        ListIterator liter = fromClause.getFromElements().listIterator(fromClause.getFromElements().size());
        while (liter.hasPrevious()) {
            orderedFromElements.add(liter.previous());
        }
        Iterator iter = orderedFromElements.iterator();
        while (iter.hasNext()) {
            final FromElement fromElement = (FromElement)iter.next();
            JoinSequence join = fromElement.getJoinSequence();
            join.setSelector(new JoinSequence.Selector(){

                public boolean includeSubclasses(String alias) {
                    boolean shallowQuery = JoinProcessor.this.queryTranslatorImpl.isShallowQuery();
                    boolean containsTableAlias = fromClause.containsTableAlias(alias);
                    boolean includeSubclasses = fromElement.isIncludeSubclasses();
                    boolean subQuery = fromClause.isSubQuery();
                    return includeSubclasses && containsTableAlias && !subQuery && !shallowQuery;
                }
            });
            this.addJoinNodes(query, join, fromElement, inSubquery);
        }
    }

    private void addJoinNodes(QueryNode query, JoinSequence join, FromElement fromElement, boolean inSubquery) {
        JoinFragment joinFragment = join.toJoinFragment(inSubquery ? Collections.EMPTY_MAP : this.queryTranslatorImpl.getEnabledFilters(), fromElement.useFromFragment(), fromElement.getWithClauseFragment(), fromElement.getWithClauseJoinAlias());
        String frag = joinFragment.toFromFragmentString();
        String whereFrag = joinFragment.toWhereFragmentString();
        if (fromElement.getType() == 130 && (join.isThetaStyle() || StringHelper.isNotEmpty(whereFrag))) {
            fromElement.setType(128);
            fromElement.getJoinSequence().setUseThetaStyle(true);
        }
        if (fromElement.useFromFragment()) {
            String fromFragment = this.processFromFragment(frag, join);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using FROM fragment [" + fromFragment + "]"));
            }
            fromElement.setText(fromFragment.trim());
        }
        this.andFactory.addWhereFragment(joinFragment, whereFrag, query, fromElement);
    }

    private String processFromFragment(String frag, JoinSequence join) {
        String fromFragment = frag.trim();
        if (fromFragment.startsWith(", ")) {
            fromFragment = fromFragment.substring(2);
        }
        return fromFragment;
    }
}

