/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.strategy.swing;

import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import jp.sf.beanbinder.AlignType;
import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.strategy.AbsComponentStrategy;
import jp.sf.beanbinder.strategy.swing.IMEFocusListener;

public final class JTextComponentStrategy
extends AbsComponentStrategy {
    private IMEFocusListener imeFocusListener;

    public void updateDisplay(Bind bind, Object component, Object value) {
        try {
            JTextComponent textComponent = (JTextComponent)component;
            textComponent.setText(value == null ? "" : value.toString());
            this.updateComponent(bind, component);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateComponent(Bind bind, Object component) {
        JTextComponent textComponent = (JTextComponent)component;
        FocusListener[] listeners = textComponent.getFocusListeners();
        int i = 0;
        while (i < listeners.length) {
            FocusListener fl = listeners[i];
            if (fl instanceof IMEFocusListener) {
                textComponent.removeFocusListener(fl);
            }
            ++i;
        }
        if (this.imeFocusListener != null) {
            textComponent.removeFocusListener(this.imeFocusListener);
        }
        this.imeFocusListener = new IMEFocusListener(bind.getProperty(0));
        textComponent.addFocusListener(this.imeFocusListener);
        if (textComponent instanceof JTextField) {
            int align = 2;
            if (bind.getProperty(0).getHorizon().equals(AlignType.LEFT)) {
                align = 2;
            }
            if (bind.getProperty(0).getHorizon().equals(AlignType.CENTER)) {
                align = 0;
            }
            if (bind.getProperty(0).getHorizon().equals(AlignType.RIGHT)) {
                align = 4;
            }
            ((JTextField)textComponent).setHorizontalAlignment(align);
        }
    }

    public void setEditable(Bind bind, Object component) {
        ((JTextComponent)component).setEditable(bind.getProperty(0).isEditable());
    }

    public Object getValue(Bind bind, Object component) {
        return ((JTextComponent)component).getText();
    }
}

