/*
 * Decompiled with CFR 0.152.
 */
package dao.hibernate;

import dao.ProductDao;
import java.io.Serializable;
import java.util.List;
import model.Product;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductDaoImpl
implements ProductDao {
    private Session session;

    public ProductDaoImpl(Session session) {
        this.session = session;
    }

    @Override
    public void save(Product product) throws Exception {
        this.session.saveOrUpdate((Object)product);
    }

    @Override
    public Product findById(Long id) throws Exception {
        return (Product)this.session.load(Product.class, (Serializable)id);
    }

    @Override
    public void delete(Product product) throws Exception {
        this.session.delete((Object)product);
    }

    @Override
    public List<Product> findAll() throws Exception {
        Criteria criteria = this.session.createCriteria(Product.class);
        return criteria.list();
    }

    @Override
    public List<Product> findByCategoryName(String name) throws Exception {
        Criteria criteria = this.session.createCriteria(Product.class).createAlias("category", "c").add((Criterion)Restrictions.like((String)"c.name", (Object)("%" + name + "%")));
        return criteria.list();
    }

    @Override
    public List<Product> findByName(String name) throws Exception {
        Criteria criteria = this.session.createCriteria(Product.class).add((Criterion)Restrictions.like((String)"name", (Object)("%" + name + "%")));
        return criteria.list();
    }
}

