/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.AddProduct;
import controller.DeleteProduct;
import controller.FindProduct;
import controller.SaveProduct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.annotations.AlignType;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Basic;
import jp.sf.beanbinder.annotations.Column;
import jp.sf.beanbinder.annotations.IMEMode;
import jp.sf.beanbinder.annotations.Select;
import jp.sf.beanbinder.annotations.Table;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.listener.EditListener;
import jp.sf.beanbinder.listener.EditListenerEvent;
import jp.sf.beanbinder.validator.NotNullValidator;
import jp.sf.beanbinder.validator.NumberValidator;
import jp.sf.beanbinder.validator.RangeValidator;
import jp.sf.beanbinder.validator.ValidateContainer;
import jp.sf.beanbinder.validator.ValidateDisplay;
import jp.sf.beanbinder.validator.Validator;
import jp.sf.beanbinder.validator.swing.SwingValidateDisplay;
import model.Product;
import view.CategoryCellEditor;

public class ExampleWindow
extends JFrame
implements ActionListener,
MouseListener,
EditListener {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    private Format format1 = new DecimalFormat("###,###,###");
    private ValidateDisplay validateDisplay;
    private ValidateContainer validator1 = new ValidateContainer();
    private Validator validator2;
    @Basic(objectKey="product", prop="name", imeMode=IMEMode.JP, group="group1")
    private JTextField nameTextBox = null;
    @Table(objectKey="productList", sortable=true, editListenerField="editListener1", columns={@Column(prop="code", text="\u54c1\u756a", validatorField="validator2"), @Column(prop="name", text="\u54c1\u540d", width=260, validatorField="validator2"), @Column(displayProp="category.name", valueProp="category", text="\u533a\u5206", cellEditorField="cellEditor1", validatorField="validator2", horizon=AlignType.CENTER), @Column(prop="unitPrice", text="\u5358\u4fa1", formatField="format1", validatorField="validator1", horizon=AlignType.RIGHT), @Column(prop="remarks", text="\u5099\u8003")})
    private JTable productTable = null;
    @Select(srcKey="categoryList", srcDisplayProp="name")
    private JComboBox combo = new JComboBox();
    private CellEditor cellEditor1 = new CategoryCellEditor(this.binder, this.combo);
    private EditListener editListener1;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JPanel jPanel = null;
    private JLabel jLabel1 = null;
    private JButton findButton = null;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jMenuItem = null;
    private JMenuItem jMenuItem2 = null;

    public ExampleWindow() {
        this.initialize();
        this.mapping();
        this.getFindButton().addActionListener(this);
        this.getProductTable().addMouseListener(this);
        this.getJScrollPane().addMouseListener(this);
        this.getJMenuItem().addActionListener(this);
        this.getJMenuItem2().addActionListener(this);
    }

    public void mapping() {
        this.validateDisplay = new SwingValidateDisplay(this);
        this.validator1.addValidator(new NumberValidator("\u5358\u4fa1\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002", this.validateDisplay));
        this.validator1.addValidator(new RangeValidator(0, 9999999, "\u5165\u529b\u53ef\u80fd\u306a\u7bc4\u56f2\u306f0\uff5e9999999\u307e\u3067\u3067\u3059\u3002", this.validateDisplay));
        this.validator2 = new NotNullValidator("\u5546\u54c1\u30b3\u30fc\u30c9\u30fb\u54c1\u540d\u30fb\u533a\u5206\u306f\u5fc5\u9808\u9805\u76ee\u3067\u3059", this.validateDisplay);
        this.editListener1 = this;
        new AnnotationParser(this.binder, (Object)this).parse();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.getFindButton())) {
            new FindProduct().execute(this.binder);
        }
        if (e.getSource().equals(this.getJMenuItem())) {
            new AddProduct().execute(this.binder);
        }
        if (e.getSource().equals(this.getJMenuItem2())) {
            Product product = (Product)this.binder.getSelectedValue("productTable");
            List productList = (List)this.binder.getObject("productList");
            new DeleteProduct().execute(product, productList);
            this.binder.updateComponent(".*");
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.getJPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void beginEdit(EditListenerEvent e) {
    }

    public void endEdit(EditListenerEvent e) {
        List list = (List)this.binder.getObject("productList");
        Product p = (Product)list.get(e.getRow());
        new SaveProduct().execute(p);
    }

    private void initialize() {
        this.setSize(583, 439);
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.setTitle("BeanBinder Example");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "North");
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(0, 200));
            this.jScrollPane.setViewportView(this.getProductTable());
        }
        return this.jScrollPane;
    }

    private JTable getProductTable() {
        if (this.productTable == null) {
            this.productTable = new JTable();
        }
        return this.productTable;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(new Rectangle(10, 10, 91, 21));
            this.jLabel1.setHorizontalAlignment(0);
            this.jLabel1.setText("\u54c1\u540d");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.setPreferredSize(new Dimension(1, 40));
            this.jPanel.add((Component)this.jLabel1, null);
            this.jPanel.add((Component)this.getNameTextBox(), null);
            this.jPanel.add((Component)this.getFindButton(), null);
        }
        return this.jPanel;
    }

    private JTextField getNameTextBox() {
        if (this.nameTextBox == null) {
            this.nameTextBox = new JTextField();
            this.nameTextBox.setBounds(new Rectangle(110, 10, 261, 21));
        }
        return this.nameTextBox;
    }

    private JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = new JButton();
            this.findButton.setBounds(new Rectangle(380, 10, 91, 21));
            this.findButton.setText("\u54c1\u540d\u691c\u7d22");
        }
        return this.findButton;
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJMenuItem());
            this.jPopupMenu.add(this.getJMenuItem2());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItem() {
        if (this.jMenuItem == null) {
            this.jMenuItem = new JMenuItem();
            this.jMenuItem.setText("\u65b0\u898f\u8ffd\u52a0");
        }
        return this.jMenuItem;
    }

    private JMenuItem getJMenuItem2() {
        if (this.jMenuItem2 == null) {
            this.jMenuItem2 = new JMenuItem();
            this.jMenuItem2.setText("\u524a\u9664");
        }
        return this.jMenuItem2;
    }
}

