package controller;

import java.util.List;

import model.Product;

import org.hibernate.Session;
import org.hibernate.Transaction;

import dao.ProductDao;
import dao.hibernate.HibernateUtil;
import dao.hibernate.ProductDaoImpl;
import jp.sf.beanbinder.BeanBinder;

public class DeleteProduct {

    public void execute(Product product, List<Product> source) {
        Session session=null;
        Transaction transaction=null;
        
        try {
            session = HibernateUtil.getSession();
            transaction = session.beginTransaction();
            ProductDao dao = new ProductDaoImpl(session);
            dao.delete( product );
            transaction.commit();
            
            source.remove(product);
        }catch(Exception ex) {
            transaction.rollback();
            ex.printStackTrace();
        }finally {
            session.close();
        }
    }

}
