package controller;

import java.util.List;

import jp.sf.beanbinder.BeanBinder;
import model.Product;

import org.hibernate.Session;

import dao.ProductDao;
import dao.hibernate.HibernateUtil;
import dao.hibernate.ProductDaoImpl;

public class FindProduct {

    public void execute(BeanBinder binder) {
        Session session = null;
        try {
            session = HibernateUtil.getSession();
            
            ProductDao dao = new ProductDaoImpl(session);
            List<Product> products = dao.findByName( (String)binder.getComponentValue("nameTextBox") );
            binder.setObject("productList", products);
            binder.updateComponent(".*");
        }catch(Exception e) {
            e.printStackTrace();
        }finally {
            session.close();
        }
    }

}
