package controller;

import java.util.List;

import jp.sf.beanbinder.BeanBinder;
import model.Category;

import org.hibernate.Session;

import dao.CategoryDao;
import dao.hibernate.CategoryDaoImpl;
import dao.hibernate.HibernateUtil;

public class LoadCategory {

    public void execute(BeanBinder binder) {
        Session session = null;
        try {
            session = HibernateUtil.getSession();
            CategoryDao dao = new CategoryDaoImpl(session);
            List<Category> categories = dao.findAll();
            binder.setObject("categoryList", categories);
            binder.updateComponent(".*");
        }catch(Exception e) {
            e.printStackTrace();
        }finally {
            session.close();
        }
    }

}
