package controller;

import model.Product;

import org.hibernate.Session;
import org.hibernate.Transaction;

import dao.ProductDao;
import dao.hibernate.HibernateUtil;
import dao.hibernate.ProductDaoImpl;

public class SaveProduct {

    public void execute(Product product) {
        Session session=null;
        Transaction transaction=null;
        
        try {
            session = HibernateUtil.getSession();
            transaction = session.beginTransaction();
            ProductDao dao = new ProductDaoImpl(session);
            dao.save( product );
            transaction.commit();
        }catch(Exception ex) {
            transaction.rollback();
            ex.printStackTrace();
        }finally {
            session.close();
        }
    }

}
