package dao.hibernate;

import java.util.List;

import model.Category;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import dao.CategoryDao;

public class CategoryDaoImpl implements CategoryDao {
    private Session session;
    
    public CategoryDaoImpl(Session session) {
        this.session = session;
    }
    public void save(Category category) throws Exception {
        this.session.saveOrUpdate(category);
    }
    
    public Category findById(Long id) throws Exception {
        return (Category)this.session.load(Category.class, id);
    }
    
    public void delete(Category category) throws Exception {
        this.session.delete(category);
    }

    public List<Category> findAll() throws Exception {
        Criteria criteria = this.session.createCriteria(Category.class);
        return criteria.list();
    }

    public List<Category> findByName(String name) throws Exception {
        Criteria criteria = this.session.createCriteria(Category.class)
                                        .add(Restrictions.like("name", "%"+name+"%"));
        return criteria.list();
    }
}
