package dao.hibernate;

import java.io.File;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
    private static final SessionFactory sessionFactory;
    
    static {
        Configuration configuration = new AnnotationConfiguration();
        File file = new File("./custom-hibernate.cfg.xml");
        //もしカスタムコンフィグファイルがあるのならば、それを優先する。
        if( file.exists() ) {
            configuration.configure(file);//この時点でhibernate.cfg.xmlから構成をロードする。
        }else {
            configuration.configure();//この時点でhibernate.cfg.xmlから構成をロードする。
        }
        
        sessionFactory = configuration.buildSessionFactory();
    }
    
    private HibernateUtil(){}
    
    public static Session getSession() {
        return sessionFactory.openSession();
    }
}
