package test;

import junit.framework.TestCase;
import model.Category;

import org.hibernate.Session;
import org.hibernate.Transaction;

import dao.CategoryDao;
import dao.hibernate.CategoryDaoImpl;
import dao.hibernate.HibernateUtil;

public class CreateCategory extends TestCase {
    public void test() {
        Session session=null;
        Transaction transaction=null;
        try {
            session = HibernateUtil.getSession();
            CategoryDao categoryDao = new CategoryDaoImpl(session);            
            transaction = session.beginTransaction();
            
            Category c = new Category();
            c.setName("家電");
            categoryDao.save(c);
            
            c = new Category();
            c.setName("衣類");
            categoryDao.save(c);
            
            c = new Category();
            c.setName("雑貨");
            categoryDao.save(c);
            
            transaction.commit();
        }catch(Exception e) {
            transaction.rollback();
            e.printStackTrace();
        }finally {
            session.close();
        }
    }
}
