package test;

import java.math.BigDecimal;

import junit.framework.TestCase;
import model.Category;
import model.Product;

import org.hibernate.Session;
import org.hibernate.Transaction;

import dao.CategoryDao;
import dao.ProductDao;
import dao.hibernate.CategoryDaoImpl;
import dao.hibernate.HibernateUtil;
import dao.hibernate.ProductDaoImpl;

public class CreateProduct extends TestCase {
    public void test() {
        Session session=null;
        Transaction transaction=null;
        try {
            session = HibernateUtil.getSession();
            CategoryDao categoryDao = new CategoryDaoImpl(session);
            ProductDao productDao = new ProductDaoImpl(session);
            transaction = session.beginTransaction();
            
            Category cat = categoryDao.findByName("家電").get(0);
            Product p = new Product();
            p.setCode("A00001");
            p.setName("HDDレコーダー");
            p.setUnitPrice(new BigDecimal(240000));
            p.setCategory(cat);
            productDao.save(p);
            
            
            cat = categoryDao.findByName("雑貨").get(0);
            p = new Product();
            p.setCode("B00001");
            p.setName("レンズクリーナー");
            p.setUnitPrice(new BigDecimal(520));
            p.setCategory(cat);
            productDao.save(p);
            
            cat = categoryDao.findByName("雑貨").get(0);
            p = new Product();
            p.setCode("B00002");
            p.setName("CDラック");
            p.setUnitPrice(new BigDecimal(1000));
            p.setCategory(cat);
            productDao.save(p);
            
            transaction.commit();
        }catch(Exception e) {
            transaction.rollback();
            e.printStackTrace();
        }finally {
            session.close();
        }
    }
}
