package test;

import junit.framework.TestCase;
import model.Category;

import org.hibernate.Session;
import org.hibernate.Transaction;

import dao.CategoryDao;
import dao.hibernate.CategoryDaoImpl;
import dao.hibernate.HibernateUtil;

public class DeleteCategory extends TestCase {

    public void test() {
        Session session=null;
        Transaction transaction=null;
        try {
            session = HibernateUtil.getSession();
            CategoryDao categoryDao = new CategoryDaoImpl(session);            
            transaction = session.beginTransaction();
            
            for(Category c : categoryDao.findAll()) {
                categoryDao.delete(c);
            }
            
            transaction.commit();
            
            assertEquals(categoryDao.findAll().size(), 0);
        }catch(Exception e) {
            transaction.rollback();
            e.printStackTrace();
        }finally {
            session.close();
        }
    }
}
