package test;

import junit.framework.TestCase;
import model.Product;

import org.hibernate.Session;
import org.hibernate.Transaction;

import dao.ProductDao;
import dao.hibernate.HibernateUtil;
import dao.hibernate.ProductDaoImpl;

public class DeleteProduct extends TestCase {

    public void test() {
        Session session=null;
        Transaction transaction=null;
        try {
            session = HibernateUtil.getSession();
            ProductDao productDao = new ProductDaoImpl(session);            
            transaction = session.beginTransaction();
            
            for(Product p : productDao.findAll()) {
                productDao.delete(p);
            }
            
            transaction.commit();
            
            assertEquals(productDao.findAll().size(), 0);
        }catch(Exception e) {
            transaction.rollback();
            e.printStackTrace();
        }finally {
            session.close();
        }
    }
}
