package test;

import java.util.List;

import junit.framework.TestCase;
import model.Category;

import org.hibernate.Session;

import dao.CategoryDao;
import dao.hibernate.CategoryDaoImpl;
import dao.hibernate.HibernateUtil;

public class FindCategory extends TestCase {

    public void testFindAll() {
        Session session=null;
        try {
            session = HibernateUtil.getSession();
            CategoryDao categoryDao = new CategoryDaoImpl(session);
            List<Category>  categories = categoryDao.findAll();
            assertEquals(categories.size(), 3);
            
            categories = categoryDao.findByName("衣類");
            assertEquals(categories.size(), 1);
        }catch(Exception e) {
            e.printStackTrace();
        }finally {
            session.close();
        }
    }
}
