package test;

import java.util.List;

import junit.framework.TestCase;
import model.Product;

import org.hibernate.Session;

import dao.ProductDao;
import dao.hibernate.HibernateUtil;
import dao.hibernate.ProductDaoImpl;

public class FindProduct extends TestCase {

    public void testFindAll() {
        Session session=null;
        try {
            session = HibernateUtil.getSession();
            ProductDao productDao = new ProductDaoImpl(session);
            List<Product>  products = productDao.findAll();
            assertEquals(products.size(), 3);
            
            products = productDao.findByName("HDD");
            assertEquals(products.size(), 1);
            
            products = productDao.findByCategoryName("雑貨");
            assertEquals(products.size(), 2);
        }catch(Exception e) {
            e.printStackTrace();
        }finally {
            session.close();
        }
    }
}
