/**
 * VBScore
 * create date 2006/09/21
 * amonden
 */
package jp.co.powerbeans.common.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * PBBeanUtil
 * @author amonden
 * @create date 2006/09/21
 */
public class PBBeanUtil {

	private static Map beanInfoCache = new HashMap();

	private PBBeanUtil() {
		
	}

	/**
	 * @param class1
	 * @param attrFromProperty
	 * @return
	 */
	public static Method getReadMethodByProperty(Class cls, String prop_name) {
		
		String key = cls.getName() + "." + prop_name;
		if (!beanInfoCache.containsKey(key)) {
			BeanInfo beaninfo;
			try {
				beaninfo = Introspector.getBeanInfo(cls);
			} catch (IntrospectionException e) {
				throw new RuntimeException(e);
			}
			PropertyDescriptor[] props = beaninfo.getPropertyDescriptors();
			for (int i = 0; i < props.length; i++) {
				beanInfoCache.put(cls.getName() + "." + props[i].getName(), props[i]);
			}
		}
		
		return 	((PropertyDescriptor) beanInfoCache.get(key)).getReadMethod();
	}

	public static Object getProperty(Object obj, String prop_name) {
		return getProperty(obj, prop_name, null);
	}

	public static Object getProperty(Object obj, String prop_name, Object[] args) {
		try {
			return obj == null || prop_name == null ? "" :
				getReadMethodByProperty(obj.getClass(), prop_name).invoke(obj, args);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
