package jp.co.powerbeans.docbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileCopy {

	private FileCopy() {
		
	}

	public static void copy(String src, String dst) throws IOException {
		copy(new File(src), new File(dst));
	}
	
	public static void copy(File src_obj, File dst_obj) throws IOException {
		
		if (!src_obj.exists()) {
			throw new FileNotFoundException(src_obj.getCanonicalPath() + " is not exist.");
		}
		
		// コピー元がディレクトリならコピー先をディレクトリとして扱えるかチェックする
		if (src_obj.isDirectory()) {
			if (dst_obj.exists()) {
				if (!dst_obj.isDirectory()) {
					throw new IllegalArgumentException("dst:" + dst_obj.getCanonicalPath() + " is file.");
				}
			} else {
				dst_obj.mkdirs();
			}
		}
		copyR(src_obj, dst_obj);
	}

	private static void copyR(File src_obj, File dst_obj) throws IOException {
		if (src_obj.isDirectory()) {
			File[] files = src_obj.listFiles();
			for (int i = 0; i < files.length; i++) {
				copyR(files[i], dst_obj);
			}
		} else if (dst_obj.isDirectory()) {
			// src_objファイルをdst_objディレクトリにコピー
			copyFileToFile(src_obj, new File(dst_obj.getCanonicalPath() + File.separator + src_obj.getName()));
		} else {
			// src_objファイルをdst_objファイルに上書きコピー
			copyFileToFile(src_obj, dst_obj);
		}
	}

	private static void copyFileToFile(File src_obj, File dst_obj) throws IOException {
			FileInputStream inFile = null;
			FileOutputStream outFile = null;
			FileChannel  fin = null;
			FileChannel  fout = null;

			try {
				inFile = new FileInputStream(src_obj);
				outFile = new FileOutputStream(dst_obj);

				/**
			 	 * record starting time
				 */
				long startTime = System.currentTimeMillis();

				fin = inFile.getChannel();
				fout = outFile.getChannel();
		
	                        /**
	                         * Method #1
	                         * channels have transferFrom() and transferTo()
	                         * "convenience" methods for transferring data betwen
	                         * channels.
	                         */
	                         
				// number of bytes in the original file	
				long sizeOf = fin.size();

				fin.transferTo(0, sizeOf, fout);
	                        
//	                        /**
//	                         * Method #2
//	                         * this transfers the bytes directly between the channels
//	                         * in 8KB chunks.
//	                         */
//	                         
//	                        // allocate a byte buffer that is directly accessed by the OS 
//	                        ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
//	                        
//	                        while ( (fin.read(buffer) != -1) || buffer.position() > 0) {
//	                            buffer.flip();
//	                            fout.write(buffer);
//	                            buffer.compact();
//	                        }
	                        

				/**
			 	 * record ending time and record the time
				 */
				System.out.println("copy " + src_obj.getCanonicalPath() + " > " + dst_obj.getCanonicalPath() + " Time: " + (System.currentTimeMillis() - startTime) );
			}
			catch (FileNotFoundException fnfe) {
				throw fnfe;
			}
			finally {
				if (fin != null)
					fin.close();
				if (fout != null)
					fout.close();
				if (inFile != null)
					inFile.close();
				if (outFile != null)
					outFile.close();
			}
	}
}
