package jp.co.powerbeans.docbuild;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import jp.co.powerbeans.docbuild.exp.SmartyExpWriter;

public class HTMLBuilder extends PBDocumentBuilderBase {


	private String charset;

	public HTMLBuilder(String template_path, String charset) {
		super(template_path);
		this.charset = charset;
	}

	/* (非 Javadoc)
	 * @see jp.co.powerbeans.docbuild.PBDocumentBuilder#output(java.lang.String)
	 */
	public void output(String out_file) {
		// super.outputを実行しておく
		super.output(out_file);
		{
			// 1. 出力ファイルのディレクトリを作成
			File file = new File(out_file);
			File pdir = file.getParentFile();
			try {
				if (!pdir.exists()) {
					pdir.mkdirs();
				}

				// 2. 出力ファイルを作成
				file.createNewFile();
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				return;
			}
		}
		
		// 3. 出力
		try {
			OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(out_file), this.charset);

			w.write(SmartyExpWriter.getResponse(this.tokens));
//			for (int i = 0; i < this.tempData.length; i++) {
//				Object o = tokens[i];
//			
//				if (o instanceof String) {
//					fw.write(o.toString());
//				} else if (o instanceof SmartyExp) {
//					SmartyExp exp = (SmartyExp) o;
//					fw.write(exp.getOutputString());
//				}
//			}
			
			w.flush();
			w.close();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
	}
}
