package jp.co.powerbeans.docbuild;

import java.util.ArrayList;
import java.util.List;

import jp.co.powerbeans.docbuild.exp.Exp;
import jp.co.powerbeans.docbuild.exp.SmartyExp;
import jp.co.powerbeans.docbuild.exp.SmartyExpFactory;

public class SmartyParser {

	public static Object[] parseTags(String htmlall, PBDocumentBuilder builder) {
		if (htmlall == null || htmlall.length() == 0) {
			return new Object[0];
		}
		
		if (htmlall.indexOf(Exp.SMARTY_FR) == -1) {
			return new Object[]{htmlall};
		}
		
		List<Object> res = new ArrayList<Object>();
		// いくつかの {式},{$変数名} を抜き出す 
		// 先頭のhtmlを取得
		int left = 0;
		int right = -1;
		
		if (!htmlall.startsWith(Exp.SMARTY_FR)) {
			res.add(htmlall.substring(0, htmlall.indexOf(Exp.SMARTY_FR)));
			left = htmlall.indexOf(Exp.SMARTY_FR);
		}
		
		while((left = htmlall.indexOf(Exp.SMARTY_FR, right)) != -1) {
			right = htmlall.indexOf(Exp.SMARTY_TO, left + 1);
			if (right == -1) {
				break;
			}
			right ++;
			if (htmlall.charAt(left + 1) == Exp.SMARTYC_VAR_FR) {
				// 単純変数なので{}タグひとつのみ解析
//				TODO 単純変数とネストタグを同一クラスで扱う
//				res.add(createTplVar(htmlall.substring(left, right + 1)));
				
				// タグ全体を解析させる
				String exp = htmlall.substring(left, right);
				res.add(parseSmartyNestExp(new SmartyAttr(exp, left, right, true), exp, builder));
				
			} else {
				// ループ,制御タグなので閉じタグまでを解析
				// left2 に閉じタグの"{"開始位置を設定
				SmartyAttr attr = new SmartyAttr(htmlall.substring(left, right), left, right);
				// このループの閉じタグ開始位置を取得
				int left2 = getCloseTagStart(htmlall, left);
//				int left2 = htmlall.indexOf(Exp.SMARTY_FR + Exp.SL + attr.getName(), left);
				int right2 = htmlall.indexOf(Exp.SMARTY_TO, left2) + 1;
				attr.setEndTagLeft(left2);
				attr.setEndTagRight(right2);
				
				// タグ全体を解析させる
				res.add(parseSmartyNestExp(attr, htmlall.substring(left, right2), builder));
			
				// 閉じタグから解析開始
				right = right2;
			}
			
			// 次の変数直前までを追加
			left = htmlall.indexOf(Exp.SMARTY_FR, right);
			if (left == -1) {
				// 変数がなければHTMLを追加して終了
				try {
					res.add(htmlall.substring(right));
				} catch (RuntimeException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
				break;
			} else {
				// 変数があればHTMLを追加して次ループへ
				res.add(htmlall.substring(right, left));
				right = left;
			}
		}
		
		return (Object[]) res.toArray(new Object[res.size()]);
	}
	
	/**
	 * htmlall の left から開始するタグの閉じタグ先頭位置を返す
	 * @param htmlall
	 * @param left
	 * @return
	 */
	private static int getCloseTagStart(String htmlall, int left) {
		int segnum = 0;
		
		int left2 = left;
		while((left2 = htmlall.indexOf(Exp.SMARTY_FR, left2 + 1)) != -1) {
			if (htmlall.charAt(left2 + 1) == Exp.SMARTYC_VAR_FR) {
				// 変数の開始なのでタグの終わりまで移動して次へ
				left2 = htmlall.indexOf(Exp.SMARTY_TO, left2);
				continue;
				
			} else if (htmlall.charAt(left2 + 1) == Exp.SL) {
				// 制御タグ終了
				// segnum == 0 ならleftと対応するタグなので返却
				if (segnum == 0) {
					return left2;
				} else {
					segnum --;
				}
			} else {
				// 制御タグ開始
				// カウンタをインクリメント
				segnum ++;
			}
		}
		
		throw new RuntimeException("invalid tag. near[" + left + ":" + htmlall.substring(left, left + 20) + "]");
	}

	/**
	 * subhtmlを解析
	 * @param attr
	 * @param subhtml
	 * @param builder 
	 * @return
	 */
	private static SmartyExp parseSmartyNestExp(SmartyAttr attr, String subhtml, PBDocumentBuilder builder) {
		
		SmartyExp exp = SmartyExpFactory.getInstance(attr);
		exp.parse(builder, attr, subhtml);
		return exp;
	}

}
