package jp.co.powerbeans.docbuild.exp;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.powerbeans.common.bean.PBBeanUtil;
import jp.co.powerbeans.docbuild.PBDocumentBuilder;
import jp.co.powerbeans.docbuild.SmartyAttr;
import jp.co.powerbeans.docbuild.SmartyParser;

import org.apache.commons.beanutils.BeanUtils;

public class ForeachExp implements SmartyExp {

	private PBDocumentBuilder builder;
	private String subhtml;
	private String innerHtml;
	private Object[] tokens;
	private SmartyAttr attr;

	public void parse(PBDocumentBuilder builder, SmartyAttr attr, String subhtml) {
		this.builder = builder;
		this.attr = attr;
		this.subhtml = subhtml;

		// タグ内のHTML,Smarty混在式を解析
		// ひとまず入れ子は無視
		this.innerHtml = subhtml.substring(attr.getStartTagRight() - attr.getStartTagLeft(), 
				attr.getEndTagLeft() - attr.getStartTagLeft());
		this.tokens = SmartyParser.parseTags(this.innerHtml, this.builder);
	}

	public String getOutputString() {

		StringBuffer html = new StringBuffer();
		String from = attr.get("from");
		String item = attr.get("item");
		String key = from.replaceFirst("\\" + Exp.VAR_FR,"");
	
		// データが格納されているlistを取得
		List list = (List) builder.getAssignedListMap().get(key);
		if (list == null) {
			return "";
		}
		
		// list の数だけ出力する
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			Object bean = (Object) iter.next();
			// key = item + "." + beanプロパティ名
			// value = beanプロパティ値
			// を innerMap に格納
			
			builder.getInnerValMap().clear();
			try {
				Map bean_map = BeanUtils.describe(bean);
				
				for (Iterator iterator = bean_map.keySet().iterator(); iterator.hasNext();) {
					String prop = (String) iterator.next();
					builder.getInnerValMap().put(item + "." + prop, bean_map.get(prop));
					
					// ListのList対策
					for (int i = 0; i < tokens.length; i++) {
						Object o = tokens[i];
						if (o instanceof ForeachExp) {
							ForeachExp exp = (ForeachExp) o;
							
							if (item.equals(exp.getAttrFromBase()) && prop.equals(exp.getAttrFromProperty())) {
								// item の exp.getItem() プロパティを出力するタグの場合
								// 出力リストを取得
								Object inlistobj = PBBeanUtil.getProperty(bean, exp.getAttrFromProperty());
								if (inlistobj == null) {
									continue;
								}
								List inlist = null;
								if (inlistobj.getClass().isArray()) {
									inlist = Arrays.asList(inlistobj);
								} else if (inlistobj instanceof List) {
									inlist = (List) inlistobj;
								} else {
									continue;
								}
								
								for (Iterator inliterator = inlist.iterator(); inliterator
										.hasNext();) {
									Object obj = (Object) inliterator.next();
									Map inbean_map = BeanUtils.describe(obj);
									for (Iterator initerator = inbean_map.keySet().iterator(); initerator.hasNext();) {
										String inprop = (String) initerator.next();
										builder.getInnerValMap().put(exp.getAttrItem() + "." + inprop, inbean_map.get(inprop));
									}
									// 値を出力
									html.append(SmartyExpWriter.getResponse(exp.tokens));
								}
							}
							
//							fromの 最初の名前が item と一致する場合は値を展開する
//						} else if (o instanceof VarExp) {
//							html.append(SmartyExpWriter.getResponse(o));
						}
					}
					
				}
				
			} catch (Exception e) {
				e.printStackTrace();
//				throw new RuntimeException(e);
			}
			
			
			// テンプレート出力
			// ただしForeachExp以外(2重出力されてしまうため)
			for (int i = 0; i < this.tokens.length; i++) {
				if (!(this.tokens[i] instanceof ForeachExp)) {
					html.append(SmartyExpWriter.getResponse(this.tokens[i]));
				}
			}
		}
		return html.toString();
	}

	/**
	 * {foreach from=$list1.list item="list2"} の list2 を返す
	 * @return
	 */
	private String getAttrItem() {
		return attr.get("item");
	}

	/**
	 * {foreach from=$list1.list item="list2"} の list を返す
	 * @return
	 */
	private String getAttrFromProperty() {
		String prop = attr.get("from");
		if (prop == null) {
			return "";
		}
		String[] froms = prop.replaceFirst("\\$", "").split("\\.");
		return (froms.length > 1) ? froms[1] : "";
	}

	/**
	 * {foreach from=$list1.list item="list2"} の list1 を返す
	 * @return
	 */
	private Object getAttrFromBase() {
		String prop = attr.get("from");
		return prop == null ? "" : 
			prop.replaceFirst("\\$", "").split("\\.")[0];
	}


}
