#include "defines.h"
#include <avr/io.h>
#include <avr/sleep.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include "functions.h"
#include "globals.h"

/*
	L    H
	|
	|
	+----+ =  0
	     | =  1
	     | =  2
	     | =  3
	     |    :
	+----+ = Intens
	|         :
	|         :
	|      = 62
	|      = 63 = RESOL_PWM-1
	+----+ =  0
	     | =  1
	     | =  2
 */

static uint8_t pwm_ctr = 0;
static uint16_t sec_ctr = TICKS_PER_1SEC; /* 1bvƂJE^[ */
static uint16_t blink_ctr = TICKS_PER_1SEC / 2; /* LED_ŗp 0.5bvƂJE^[ */
static uint16_t key_sample_ctr = DEBOUNCE_TICKS;
static uint16_t dimm_ctr = DIMMING_STEP;
static uint8_t curkey = 0;
static uint8_t prevkey = 0;

// 1/32000b1̃C^[o^C}[荞݁iׂẴ^C~Opj
ISR(TIMER0_OVF0_vect)
{
	TCNT0 = 0x100 - TICK_CLOCKS; /* ̃^C}[荞݃^C~OZbg */

	if (Intens == 0 || pwm_ctr == Intens)
		PORTB &= ~_BV(PWMOUT_BIT); /* PWM=L */
	else if (Intens == PWM_MAX || pwm_ctr == PWM_MAX)
		PORTB |= _BV(PWMOUT_BIT); /* PWM=H */

	pwm_ctr = (pwm_ctr + 1) & MASK_PWM_CTR;	/* PWMJE^] */

	if (--sec_ctr == 0) {	/* 1bo߂ */
		sec_ctr = TICKS_PER_1SEC;
		if (State == STATE_WAIT && Wait_ctr > 0)
			--Wait_ctr;
	}

	if (--dimm_ctr == 0) {
		dimm_ctr = DIMMING_STEP;
		if (State == STATE_DIMMING && Intens > 0)
			--Intens; /*  */
	}

	if (State == STATE_FULL)
		PORTB &= ~_BV(LED_BIT);	/* LED_ */

	if (--blink_ctr == 0) {	/* 0.5bo߂ */
		blink_ctr = TICKS_PER_1SEC / 2;
		switch(State) {
		case STATE_WAIT:
			PORTB ^= _BV(LED_BIT); /* LED_ */
			break;
		case STATE_DIMMING:
		case STATE_OFF:
			PORTB |= _BV(LED_BIT); /* LED */
			break;
		default:
			break;
		}
	}

	if (--key_sample_ctr == 0) { /* {^ZX^C~O */
		key_sample_ctr = DEBOUNCE_TICKS;

		prevkey = curkey;
		curkey = ((PINB & _BV(SW1_BIT)) == 0); /* Ă1 */
		if (prevkey == 0 && curkey == 1) /* OItI */
			Key_sense = 1; /* tHAOEhɒʒm */
	}
}

// X[ṽ{^͂ɂ銄荞
ISR(INT0_vect)
{
}
