/*
	PWMLEDǏ

	VCC---10k--+   +--------------+
	           |   |   AT90S2323  |
	GND---SW2--+--1|RESET      VCC|8--- +5V
	    [Cera]----2|XTAL1      PB2|7----LED---1k---VCC
	    [Lock]----3|XTAL2 INT0/PB1|6----SW1---GND
	              4|GND        PB0|5----4.7k------>PWM out
	               +--------------+   

dOFFON
	_
蓮Zbg(SW2)
	
_
	EPx100%
	ELED_
	SW1FX[v^C}[
	SW2F
X[v^C}[쒆
	EPx100%
	EX[v^C}[̃JEg
	ELED_Łi1Hzj
	Ă1Ԍo߁F
	SW1FX[v^C}[1ԂɃZbg
	SW2F

	E1b1XebvPx𗎂Ƃ
	ELED
	1o߁F
	SW1F邳ɖ߂āAX[v^C}[1ԂɃZbgiĂ1ԁj
	SW2F

	EPx[
	ELED
	SW1F_
	SW2F̂܂

*/

#include "defines.h"
#include <avr/io.h>
#include <avr/sleep.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <stdio.h>
#include "functions.h"

#define PUBLIC
#include "globals.h"

//
// MAIN LOOP
//
int main(void)
{
	while(1){
		switch(State) {
		case STATE_INIT:
			init_io();	/* I/Os̏ */
			timer0_init();	/* C^[o^C}[̏ */
			sei();
			if (MCUSR & _BV(PORF))
				State = STATE_FULL; /* Power-on ZbgȂ_*/
			else
				State = STATE_OFF; /* 蓮ZbgȂ */
			MCUSR &= ~_BV(PORF) & ~_BV(EXTRF);
			break;
		case STATE_FULL:
			Intens = INTENS_FULL;
			if (Key_sense == 1) {
				Key_sense = 0;
				Wait_ctr = WAIT_SEC;
				State = STATE_WAIT;
			}
			break;
		case STATE_WAIT:
			if (Wait_ctr == 0) {
				State = STATE_DIMMING;
			} else {
				if (Key_sense == 1) {
					Key_sense = 0;
					Wait_ctr = WAIT_SEC;
					State = STATE_WAIT;
				}
			}
			break;
		case STATE_DIMMING:
			if (Intens == 0) {
				State = STATE_OFF;
			} else {
				if (Key_sense == 1) {
					Key_sense = 0;
					Intens = INTENS_FULL;
					Wait_ctr = WAIT_SEC;
					State = STATE_WAIT;
				}
			}
			break;
		case STATE_OFF:
		default:
			Intens = 0;
			PORTB &= ~_BV(PWMOUT_BIT); /* PWM=L */
			GIMSK |= _BV(INT0); /* SW1̊荞݂ */
			set_sleep_mode(SLEEP_MODE_PWR_DOWN);
			sleep_mode();

			//-----------------------------------------------------
			// ̊ԃX[v(Power Down Mode)
			//
			// INT0=PINB1=LowŕA
			//-----------------------------------------------------

			GIMSK &= ~_BV(INT0); /* SW1̊荞݂֎~ */
			if (Key_sense == 1) {
				Key_sense = 0;
				State = STATE_FULL;
			}
			break;
		}
	}

	return 0;
}
