/*!
  \file
  \brief S-Format ̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SFormatHandler.h"
#include <fstream>
#include <string>


struct SFormatHandler::pImpl {
  std::string fname;
  size_t lines_count;
  std::string error_message;

  pImpl(const char* sformatFile)
    : fname(sformatFile), lines_count(0), error_message("no error.") {
  }

  static int hex2int(char ch) {
    return (ch >= '0' && ch <= '9') ? (ch - '0') : (ch - 'A' + 10);
  }
};


SFormatHandler::SFormatHandler(const char* sformatFile)
  : pimpl(new pImpl(sformatFile)) {
}


SFormatHandler::~SFormatHandler(void) {
}


const char* SFormatHandler::what(void) {
  return pimpl->error_message.c_str();
}


bool SFormatHandler::parseLine(srec_t* srec, const char* line) {

  int index = 0;
  if (line[index++] != 'S') {	// ŏ̕ 'S' ǂ
    return false;
  }
  srec->type = line[index++] - '0'; // type ̊i[

  // byte_size ̊i[
  int byte_size =
    (pImpl::hex2int(line[index]) << 4) + pImpl::hex2int(line[index + 1]);
  index += 2;

  // address ̊i[
  int addr_size = 2;
  if (srec->type >= 1 && srec->type <= 3) {
    addr_size = srec->type + 1;
  } else if (srec->type >= 7 && srec->type <= 9) {
    addr_size = 11 - srec->type;
  }
  srec->address = 0;
  for (int i = 0; i < 2*addr_size; ++i) {
    srec->address = (srec->address << 4) + pImpl::hex2int(line[index++]);
  }

  // byte_data ̊i[
  srec->data_size = byte_size - addr_size - 1;
  for (int i = 0; i < srec->data_size; ++i) {
    srec->byte_data[i] =
      (pImpl::hex2int(line[index]) << 4) + pImpl::hex2int(line[index + 1]);
    index += 2;
  }

  // check sum ̎擾ƃ`FbN
  int check_sum =
    (pImpl::hex2int(line[index]) << 4) + pImpl::hex2int(line[index + 1]);
  index += 2;
  int data_sum = 0;
  for (int i = 0; i <= (srec->data_size + addr_size); ++i) {
    data_sum +=
      (pImpl::hex2int(line[2*i+2]) << 4) + pImpl::hex2int(line[2*i+3]);
  }
  if (check_sum != (~data_sum & 0xff)) {
    return false;
  }

  return true;
}


bool SFormatHandler::eachLines(LineHandler callback, void* args) {
    std::ifstream fd(pimpl->fname.c_str());
  if (! fd.is_open()) {
    pimpl->error_message = "file is not found.";
    return false;
  }

  pimpl->lines_count = 0;
  while (! fd.eof()) {
    std::string line;
    getline(fd, line);

    // s𖳎As S-Format ̊mFs
    if (line.size() > 0) {
      srec_t srec;
      bool ret = parseLine(&srec, line.c_str());
      if (! ret) {
	pimpl->error_message = "S-format syntax error";
	return false;
      }
      if (callback) {
	ret = callback(&srec, args);
      }
      if (! ret) {
	return false;
      }
      ++pimpl->lines_count;
    }
  }

  return true;
}


size_t SFormatHandler::getLinesNum(void) {
  return pimpl->lines_count;
}


unsigned long SFormatHandler::getStartAddress(void) {

  // !!!
  return 0;
}
