/*!
  \file
  \brief F-ZTAT p̃f[^Ă݃vO

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SFormatHandler.h"
#ifdef MONITOR
#include "mFZtatHandler.h"
#else
#include "FZtatHandler.h"
#endif
#include "DetectOS.h"
#include <stdlib.h>


#if defined(LINUX_OS)
static const char* DefaultSerialDevice = "/dev/ttyS0";
static const long DefaultBaudrate = 115200;

#elif defined(WINDOWS_OS)
static const char* DefaultSerialDevice = "COM1";
static const long DefaultBaudrate = 115200;

#elif defined(MAC_OS)
// !!!  MAC_OS ǉ
#else
// !!! xbZ[W̕\
#endif


class ArgsInfo {
public:
  const char* sformatFile;
  const char* serialDevice;
  long baudrate;
  const char* targetCpu;
  bool simulator;

  ArgsInfo(void)
    : sformatFile(NULL), serialDevice(DefaultSerialDevice),
      baudrate(DefaultBaudrate),
      targetCpu("SH7040"), simulator(false) {}
};


static void printHelp(const char* progname) {
  printf("usage:\n"
	 "\t%s [options] <S-Fromat file>\n"
	 "\n"
	 "options:\n"
	 "-h, --help\t\tprint this message.\n"
	 "-v, --version\t\tprint version message.\n"
	 "--port=<PORT>\t\tspecify serial device. (default %s)\n"
	 "--baudrate=<BAUDRATE>\tspecify write baudrate. "
	 "(default %ld bps)\n\n",
	 progname, DefaultSerialDevice, DefaultBaudrate);
}


static void parseArgs(ArgsInfo& info, int argc, char *argv[]) {

  for (int i = 1; i < argc; ++i) {

    if ((! strcmp("-s", argv[i])) || (! strcmp("--simulator", argv[i]))) {
      // V~[V[h
      info.simulator = true;

    } else if (! strncmp("--port=", argv[i], 7)) {
      // ڑfoCX̍XV
      info.serialDevice = &argv[i][7];

    } else if (! strncmp("--baudrate=", argv[i], 11)) {
      // ʐM{[[g̍XV
      info.baudrate = atoi(&argv[i][11]);

    } else if ((! strcmp("-v", argv[i])) || (! strcmp("--version", argv[i]))) {
      // !!! Õo[W𔽉f
      printf("sh2writer 0.0.1\n\n");
      exit(0);

    } else if ((! strcmp("-h", argv[i])) || (! strcmp("--help", argv[i]))) {
      printHelp(argv[0]);
      exit(0);

    } else {
      // S-Format ̃t@CƂēo^
      info.sformatFile = argv[i];
    }
  }
}


int main(int argc, char *argv[]) {

  // ̉
  ArgsInfo info;
  parseArgs(info, argc, argv);

  if (info.sformatFile == NULL) {
    printf("no data file.\n");
    // !!! --help ̓e\ׂȁH
    exit(1);
  }

  // ]t@C̃tH[}bgmF
  SFormatHandler sformat(info.sformatFile);
  if (! sformat.eachLines(NULL, NULL)) {
    printf("%s: %s\n", info.sformatFile, sformat.what());
    exit(1);
  }

  // ]
#ifdef MONITOR
  mFZtatHandler fztat;
  if (info.simulator) {
    fztat.activateSimulator();
  }
#else
  FZtatHandler fztat;
#endif
  if (! fztat.connect(info.serialDevice, info.baudrate)) {
    printf("%s : device is %s.\n", fztat.what(), info.serialDevice);
    exit(1);
  }
  //fztat.setTargetCpu(info.targetCpu);

  // ݏ
  if (! fztat.write(sformat)) {
    printf("writing is fail: %s\n", fztat.what());
    exit(1);
  }

  fprintf(stderr, "\nexit normaly.\n");
  return 0;
}
