/*!
  \file
  \brief S-Format [_[

  \author Satofumi KAMIMURA

  $Id$
*/

#include "DetectOS.h"
#include "SFormatHandler.h"
#include "FZtatHandler.h"
#include "ConnectionInterface.h"
#include "StandardInput.h"
#ifdef MONITOR
#include "LoaderTargetSimulator.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string>


// !!! ̂Ash2writer ƋʂɂłȂȁH
#if defined(LINUX_OS)
static const char* DefaultSerialDevice = "/dev/ttyS0";
static const long DefaultBaudrate = 115200;

#elif defined(WINDOWS_OS)
static const char* DefaultSerialDevice = "COM1";
static const long DefaultBaudrate = 115200;

#elif defined(MAC_OS)
// !!!  MAC_OS ǉ
#else
// !!! xbZ[W̕\
#endif


class ArgsInfo {
public:
  const char* sformatFile;
  const char* serialDevice;
  long baudrate;
  long terminalBaudrate;
  const char* targetCpu;
  bool simulator;

  ArgsInfo(void)
    : sformatFile(NULL), serialDevice(DefaultSerialDevice),
      baudrate(DefaultBaudrate),
      targetCpu("SH7040"), simulator(false) {
  }
};


static void printHelp(const char* progname) {
  printf("usage:\n"
	 "\t%s [options] <S-Fromat file>\n"
	 "\n"
	 "options:\n"
	 "-h, --help\t\tprint this message.\n"
	 "-v, --version\t\tprint version message.\n"
	 "--port=<PORT>\t\tspecify serial device. (default %s)\n"
	 "--baudrate=<BAUDRATE>\tspecify send baudrate. (default %ld bps)\n"
	 "--t_baudrate=<BAUDRATE>\tspecify terminal baudrate. "
	 "(default %ld bps)\n",
	 progname, DefaultSerialDevice, DefaultBaudrate, DefaultBaudrate);
}


static void parseArgs(ArgsInfo& info, int argc, char* argv[]) {

  for (int i = 1; i < argc; ++i) {
    if ((! strcmp("-s", argv[i])) || (! strcmp("--simulator", argv[i]))) {
      // V~[V[h
      info.simulator = true;

    } else if (! strncmp("--port=", argv[i], 7)) {
      // ڑfoCX̍XV
      info.serialDevice = &argv[i][7];

    } else if (! strncmp("--baudrate=", argv[i], 11)) {
      // ʐM{[[g̍XV
      info.baudrate = atoi(&argv[i][11]);

    } else if (! strncmp("--t_baudrate=", argv[i], 13)) {
      // ʐM{[[g̍XV
      info.terminalBaudrate = atoi(&argv[i][13]);

    } else if ((! strcmp("-v", argv[i])) || (! strcmp("--version", argv[i]))) {
      // !!! Õo[W𔽉f
      printf("sh2writer 0.0.1\n\n");
      exit(0);

    } else if ((! strcmp("-h", argv[i])) || (! strcmp("--help", argv[i]))) {
      printHelp(argv[0]);
      exit(0);

    } else {
      // S-Format ̃t@CƂēo^
      info.sformatFile = argv[i];
    }
  }
}


static void runTerminal(ConnectionInterface* con, long baudrate) {

  // ^[Qbg̃f[^MA^[~iւ̓͑M
  con->changeBaudrate(baudrate);
  StandardInput sio;

  // ʐM
  char buf[BUFSIZ];
  while (1) {
    int n = con->recv(buf, BUFSIZ, 0);
    if (n > 0) {
      write(1, buf, n);
    }
    n = sio.recv(buf, BUFSIZ, 100);
    if (n > 0) {
      con->send(buf, n);
    }
  }
}


int main(int argc, char *argv[]) {

  // ̉
  ArgsInfo info;
  parseArgs(info, argc, argv);

  if (info.sformatFile == NULL) {
    printf("no data file.\n");
    // !!! --help ̓e\ׂȁH
    exit(1);
  }

  // ]t@C̃tH[}bgmF
  SFormatHandler sformat(info.sformatFile);
  if (! sformat.eachLines(NULL, NULL)) {
    printf("%s: %s\n", info.sformatFile, sformat.what());
    exit(1);
  }

  // vO̓]
  FZtatHandler fztat;
#ifdef MONITOR
  LoaderTargetSimulator simulator(fztat);
  if (info.simulator) {
    simulator.activate();
  }
#else
  if (0) {
  }
#endif
 else {
    if (! fztat.connect(info.serialDevice, info.baudrate)) {
      printf("%s : device is %s.\n", fztat.what(), info.serialDevice);
      exit(1);
    }
  }
  ConnectionInterface*& con = fztat.getConnection();

  con->send("S", 1);
  if (! fztat.sendSrecData(sformat)) {
    // !!! error_message
    fprintf(stderr, "send data fail: %s\n", fztat.what());
    exit(1);
  }
  // AhX̓]
  printf("\n");
  con->send("Q", 1);
  if (! fztat.sendStartAddress()) {
    fprintf(stderr, "send address fail.\n");
    exit(1);
  }
  enum { Timeout = 64 };
  char recv_ch;
  con->recv(&recv_ch, 1, Timeout);


  // ^[~i
  runTerminal(con, info.terminalBaudrate);

  return 0;
}
