/*!
  \file
  \brief Obh^̒`

  \author Satofumi KAMIMURA

  $Id$
*/

#include "GridTypes.h"


double Angle::toRad(void) const {
  return 0.0;
}


//////////////////////////////////////////////////////////////////////
Grid::Grid(const int x_value, const int y_value) : x(x_value), y(y_value) {
}


//////////////////////////////////////////////////////////////////////
Position::Position(void) : x(0), y(0), radian(0.0) {
}


Position::Position(const int x_value, const int y_value,
		   const Angle angle_value)
  : x(x_value), y(y_value), radian(angle_value.toRad()) {
}


Position::Position(const Position& rhs)
  : x(rhs.x), y(rhs.y), radian(rhs.radian) {
}


Position& Position::operator = (const Position& rhs) {
  this->x = rhs.x;
  this->y = rhs.y;
  this->radian = rhs.radian;

  return *this;
}


Position::~Position(void) {
}


//////////////////////////////////////////////////////////////////////
Grid3D::Grid3D(void) : x(0), y(0), z(0) {
}


Grid3D::Grid3D(const Grid3D& rhs) : x(rhs.x), y(rhs.y), z(rhs.x) {
  // !!! 킴킴Lq̂AǂƎvBftHgłƂɂ邩ȁH
}


Grid3D::~Grid3D(void) {
}


//////////////////////////////////////////////////////////////////////
Angle deg(const int degree) {
  return Angle();
}


void set_Position(Position* obj, int x, int y, double radian) {
  obj->x = x;
  obj->y = y;
  obj->radian = radian;
}


void set_Grid3D(Grid3D* obj, int x, int y, int z) {
  obj->x = x;
  obj->y = y;
  obj->z = z;
}
