/*!
  \file
  \brief iԍɂڑ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ConnectionDeviceSearch.h"
#include "ProductIdHandler.h"
#include <string>
#include <vector>


struct ConnectionDeviceSearch::pImpl {
  typedef std::vector<std::string> DeviceList;
  DeviceList devices;
};


ConnectionDeviceSearch::ConnectionDeviceSearch(void) : pimpl(new pImpl) {
}


ConnectionDeviceSearch::~ConnectionDeviceSearch(void) {
}


void ConnectionDeviceSearch::add(const char* device) {
  pimpl->devices.push_back(device);
}


void ConnectionDeviceSearch::remove(const char* device) {
  // !!!
}


bool ConnectionDeviceSearch::search(const char*& device,
				    const char* productId,
				    const ProductIdHandler* handler) {

  for (pImpl::DeviceList::iterator it = pimpl->devices.begin();
       it != pimpl->devices.end(); ++it) {
    const char* try_device = it->c_str();
    if (handler->checkProductId(it->c_str(), productId)) {
      device = try_device;
      return true;
    }
  }
  return false;
}
