#ifndef RING_BUFFER_H
#define RING_BUFFER_H

/*!
  \file
  \brief Oobt@

  \author Satofumi KAMIMURA

  $Id$
*/

#include <vector>


/*!
  \brief Oobt@
*/
template<class C> class RingBuffer {
  RingBuffer(const RingBuffer& rhs);
  RingBuffer& operator = (const RingBuffer& rhs);

  std::vector<C> ring_buffer;
  size_t buffer_size;
  size_t first;
  size_t last;

  size_t free_size(void) {
    return buffer_size -1 - size();
  }

public:
  explicit RingBuffer(size_t defaultSize = 0)
    : buffer_size(0), first(0), last(0) {
    if (defaultSize > 0) {
      size_t buffer_size = 1;
      while (buffer_size < defaultSize) {
	buffer_size *= 2;
      }
      ring_buffer.resize(buffer_size);
    }
  }


  ~RingBuffer(void) {
  }

  size_t size(void) {
    return (last >= first) ? last - first : buffer_size - (first - last);
  }

  void put(const C* data, size_t size) {

    long need_size = size - free_size();
    if (need_size > 0) {
      // obt@ɓ肫ȂꍇAg
      size_t extend_size = (buffer_size == 0) ? 1 : buffer_size;
      while (need_size > 0) {
	need_size -= extend_size;
	extend_size *= 2;
      }
      ring_buffer.resize(extend_size);

      // gTCYɍ킹ăf[^ړ
      if (first > last) {
	// 0  last ܂ł̃f[^Abuffer_size ȍ~Ɉړ
	memmove(&ring_buffer[buffer_size], &ring_buffer[0], last * sizeof(C));
	last += buffer_size;
      }
      buffer_size = extend_size;
    }
    // f[^zu
    if (first <= last) {
      // last  buffer_size I[܂łɔzu
      size_t to_end = buffer_size - last;
      size_t move_size = (to_end > size) ? size : to_end;
      memmove(&ring_buffer[last], data, move_size * sizeof(C));
      last += move_size;
      last &= (buffer_size -1);

      long left_size = size - move_size;
      if (left_size > 0) {
	// 0  first ̑O܂łzu
	memmove(&ring_buffer[0], &data[move_size], left_size * sizeof(C));
	last = left_size;
      }
    } else {
      // last  first ̑O܂Ŕzu
      memmove(&ring_buffer[last], data, size * sizeof(C));
      last += size;
    }
  }

  size_t get(C* data, size_t size) {
    // f[^擾
    size_t return_size = (size <= this->size()) ? size : this->size();

    if (first <= last) {
      memmove(data, &ring_buffer[first], return_size * sizeof(C));
      first += return_size;
    } else {
      // first  buffer_size I[܂łzu
      size_t to_end = buffer_size - first;
      size_t move_size = (to_end > return_size) ? return_size : to_end;
      memmove(data, &ring_buffer[first], move_size * sizeof(C));
      first += move_size;
      first &= (buffer_size -1);

      long left_size = return_size - move_size;
      if (left_size > 0) {
	// 0  last ̑O܂łzu
	memmove(&data[move_size], &ring_buffer[0], left_size * sizeof(C));
	first = left_size;
      }
    }
    return return_size;
  }

  void clear(void) {
    first = 0;
    last = 0;
  }
};

#endif /* !RING_BUFFER_H */
