/*!
  \example
  \brief Wii ̉x̕\

  \author Satofumi KAMIMURA

  $Id$
*/

#include "WiiJoystick.h"
#include "Delay.h"


int main(int argc, char *argv[]) {

  printf("Put Wiimote in discoverable mode (press 1+2) and press RETURN\n");
  getchar();

  WiiJoystick joystick;
  if (! joystick.connect()) {
    printf("WiiJoysticks::connect: %s\n", joystick.what());
    exit(1);
  }
  printf("Put Home button to terminate this program.\n");

  while (1) {
    // Home {^Ń[v𔲂
    if (joystick.isButtonPressed(WiiJoystick::Button_Home)) {
      break;
    }

    // x̕\
    double acc_x, acc_y, acc_z, roll, pitch;
    joystick.getAccelerations(&acc_x, &acc_y, &acc_z, &roll, &pitch);

    printf("acc: %.2f, %.2f, %.2f, roll: %.2f, pitch: %.2f\n",
	   acc_x, acc_y, acc_z, roll, pitch);

    delay(50);
  }
  return 0;
}
