/*!
  \file
  \brief ʐM̋L^

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ConnectionLogger.h"
#include "TcpipCtrl.h"
#include <string>
#include <fstream>


/*!
  \brief ConnectionLogger ̓NX
*/
struct ConnectionLogger::pImpl {
  ConnectionInterface* con;
  std::string base_name;
  std::fstream fd_recv;
  std::fstream fd_send;

  pImpl(ConnectionInterface* con_obj) : con(con_obj), base_name("tcpipLog") {
    if (con == NULL) {
      // !!! LogManager
      throw;
    }
  }

  ~pImpl(void) {
    terminate();
    delete con;
  }

  void open(void) {
    if (! fd_recv.is_open()) {
      std::string recv_file = base_name + "_recv.txt";
      fd_recv.open(recv_file.c_str(), std::ios::out | std::ios::binary);

      std::string send_file = base_name + "_send.txt";
      fd_send.open(send_file.c_str(), std::ios::out | std::ios::binary);
    }
  }

  void terminate(void) {
    if (fd_recv.is_open()) {
      fd_recv.close();
      fd_send.close();
    }
  }
};


ConnectionLogger::ConnectionLogger(ConnectionInterface* con)
  : pimpl(new pImpl(con)) {
}


ConnectionLogger::~ConnectionLogger(void) {
}


const char* ConnectionLogger::what(void) {
  return pimpl->con->what();
}


int ConnectionLogger::connect(const char* host, long port) {

  pimpl->open();
  return pimpl->con->connect(host, port);
}


void ConnectionLogger::disconnect(void) {
  pimpl->con->disconnect();
}


bool ConnectionLogger::isConnected(void) {
  return pimpl->con->isConnected();
}


int ConnectionLogger::changeBaudrate(long baudrate) {
  return pimpl->con->changeBaudrate(baudrate);
}


int ConnectionLogger::send(const char* data, int size) {

  if (size > 0) {
    // data ̓et@Cɏo
    pimpl->fd_send.write(data, size);
    pimpl->fd_send.flush();
  }
  return pimpl->con->send(data, size);
}


int ConnectionLogger::recv(char* data, int size, int timeout) {

  int n = pimpl->con->recv(data, size, timeout);

  if (n > 0) {
    // data ̓et@Cɏo
    pimpl->fd_recv.write(data, n);
    pimpl->fd_recv.flush();
  }
  return n;
}


int ConnectionLogger::size(int timeout) {
  return pimpl->con->size(timeout);
}


void ConnectionLogger::clear(void) {
  return pimpl->con->clear();
}


void ConnectionLogger::setLogfileName(const char* logfileName) {
  pimpl->base_name = logfileName;
}


void ConnectionLogger::skip(int timeout) {
  clear();

  char buffer[BUFSIZ];
  int total = 0;
  int n;

  enum { EachTimeout = 10 };
  do {
    n = recv(buffer, BUFSIZ, EachTimeout);
    total += EachTimeout;
  } while ((n > 0) && ((timeout > 0) && (total < timeout)));
}
