#ifndef NMEA_HANDLER_H
#define NMEA_HANDLER_H

/*!
  \file
  \brief NMEA nh

  \author Satofumi KAMIMURA

  $Id$

  \todo N񂪎擾łȂƂ́AoԂ̎擾܂ǂɂ
*/

#include <memory>
#include "GridTypes.h"

class NmeaState;


/*!
  \brief NMEA vgȐNX
*/
class NmeaHandler {
  NmeaHandler(const NmeaHandler& rhs);
  NmeaHandler& operator = (const NmeaHandler& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  NmeaHandler(void);
  ~NmeaHandler(void);

  const char* what(void);
  bool updateState(NmeaState* state, const char* line);

  static void getGrid3D(Grid3D<double>* position,
			const NmeaState* point, const NmeaState* origin);
  static double getLength(const NmeaState* point, const NmeaState* origin);
};

#endif /* !NMEA_HANDLER_H */
