/*!
  \file
  \brief PolStar  PGM-238 

  \author Satofumi KAMIMURA

  $Id$

  \todo SerialCtrl::getline() g悤ɕύX
*/

#include "Pgm238Ctrl.h"
#include "NmeaHandler.h"
#include "SerialCtrl.h"
#include "GetTicks.h"


/*!
  \brief Pgm238Ctrl ̓NX
*/
struct Pgm238Ctrl::pImpl {
  enum {
    Baudrate = 4800,
    Timeout = 10,
    VersionTimeout = 200,
    VersionCheckTimes = 5, // (Kv 2 ) + (Ή 1 ) + (\ 2 )
  };
  std::string error_message;
  std::string version_line;
  SerialCtrl con;
  std::string line_buffer;
  NmeaHandler nmea;
  size_t last_ticks;

  pImpl(void) : error_message("no error."), version_line(""), last_ticks(0) {
  }

  bool isLf(char ch) {
    return ((ch == '\r') || (ch == '\n')) ? true : false;
  }

  int readLine(std::string& data, int timeout) {

    int n;
    do {
      char ch;
      n = con.recv(&ch, 1, timeout);
      if (n <= 0) {
	return -1;
      }
      if (isLf(ch)) {
	data = line_buffer;
	line_buffer.clear();
	return data.size();
      }
      line_buffer.push_back(ch);
    } while (n > 0);

    return -1;
  }
};


Pgm238Ctrl::Pgm238Ctrl(void) : pimpl(new pImpl) {
}


Pgm238Ctrl::~Pgm238Ctrl(void) {
}


const char* Pgm238Ctrl::what() {
  return pimpl->error_message.c_str();
}


bool Pgm238Ctrl::connect(const char* device) {

  disconnect();
  int ret = pimpl->con.connect(device, pImpl::Baudrate);
  if (ret < 0) {
    pimpl->error_message = pimpl->con.what();
    return false;
  }

  // ڑƂ̃o[WmF
  pimpl->con.skip();
  pimpl->con.send("@PV\r\n", 5);

  // nn{ɐݒ
  pimpl->con.send("@SKB\r\n", 6);

  // o[WۂɎ擾
  for (int i = 0; i < pImpl::VersionCheckTimes; ++i) {
    std::string line;
    pimpl->readLine(line, pImpl::VersionTimeout);
    if (line.size() == 0) {
      continue;
    }
    if (! line.compare(0, 4, "[PV]")) {
      pimpl->version_line = line;
      return true;
    }
  }

  pimpl->error_message = "version check fail.";
  return false;
}


void Pgm238Ctrl::disconnect(void) {
  pimpl->con.disconnect();
  pimpl->version_line = "";
  pimpl->last_ticks = 0;
}


bool Pgm238Ctrl::isConnected(void) {
  return pimpl->con.isConnected();
}


bool Pgm238Ctrl::updateState(NmeaState* state, std::string& line) {

  // !!! ScipHandler Ȃǂ readLine ܂߁AʃNXɂׂH
  // !!! ׂB́Aʓrgނ...
  // !!!
  bool state_changed = false;
  while (1) {
    int n = pimpl->readLine(line, pImpl::Timeout);
    if (n == 0) {
      // ŝƂ̏ꍇ
      continue;
    }
    if (n < 0) {
      return state_changed;
    }

    // Mf[^̃p[X
    if ((line.size() > 0) && (line[0] == '$')) {
      bool ret = pimpl->nmea.updateState(state, line.c_str());
      if (ret == false) {
	pimpl->error_message = pimpl->nmea.what();
      } else {
	state_changed = true;
	pimpl->last_ticks = GetTicks();
      }
    }
    return state_changed;
  }
}


int Pgm238Ctrl::getInvalidPeriod(void) {
  return (pimpl->con.isConnected()) ?
    static_cast<int>(GetTicks() - pimpl->last_ticks) : -1;
}


void Pgm238Ctrl::setWalkMode(bool on) {
  if (on) {
    pimpl->con.send("@WLKON\r\n", 8);
  } else {
    pimpl->con.send("@WLKOFF\r\n", 9);
  }
  pimpl->con.skip();
}
