#ifndef PGM238_CTRL_H
#define PGM238_CTRL_H

/*!
  \file
  \brief PolStar  PGM-238 

  \author Satofumi KAMIMURA

  $Id$

  \todo CommonGpsCtrl āAʏϏ
*/

#include "GpsInterface.h"
#include <memory>

class NmeaState;


/*!
  \brief PolStar А Pgm-238 NX
*/
class Pgm238Ctrl : public GpsInterface {
  Pgm238Ctrl(const Pgm238Ctrl& rhs);
  Pgm238Ctrl& operator = (const Pgm238Ctrl& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  Pgm238Ctrl(void);
  ~Pgm238Ctrl(void);

  const char* what();
  bool updateState(NmeaState* state, std::string& line);
  int getInvalidPeriod(void);

  bool connect(const char* device);
  void disconnect(void);
  bool isConnected(void);
  void setWalkMode(bool on = true);
};

#endif /* !PGM238_CTRL_H */
