#include <stdio.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
//#include "def01.h"
#include "str01.h"

matrix ret_mat;
typedef double (*daryp)[MAXN][MAXN];
typedef double (dary)[MAXN][MAXN];

double abs1(double);

vector matvec(matrix inmat, vector v1)
  /*--- sƃxNg̐ */
{
  int i, j;
  vector ret_v;

  for (i=0;i<MAXN;i++) ret_v.a[i]=0.0;
  ret_v.err = 0;
  if((inmat.n>MAXN)||(inmat.n<0)||(inmat.m>MAXN)||(inmat.m<0))
    ret_v.err=1;
  if((v1.n > MAXN) || (v1.n<0)) ret_v.err=1;
  if((v1.n) != (inmat.m)) ret_v.err=1;
  if(ret_v.err == 1){ ret_v.n=0; return ret_v; }
  ret_v.n=inmat.n;
  for (i=0;i<inmat.n;i++){
    for (j=0;j<inmat.m;j++) ret_v.a[i] = ret_v.a[i] + inmat.a[i][j] * v1.a[j];
  }
  return ret_v;
}

matrix matmat(matrix *m1, matrix *m2)
  /*--- s̐ */
{
  int i, j, k, mcount;

  ret_mat.err = 0;
  if ((m1->n>MAXN)||(m1->n<0)||(m1->m>MAXN)||(m1->m<0)) ret_mat.err=1;
  if ((m2->n>MAXN)||(m2->n<0)||(m2->m>MAXN)||(m2->m<0)) ret_mat.err=1;

  if  ((m1->m) != (m2->n))  ret_mat.err=1;
  mcount = m1->m;
  if (ret_mat.err == 1){
    strcpy(ret_mat.message,"Something went wrong.");
    printf("Something went wrong!\n");
    ret_mat.n = 0;
    ret_mat.m = 0;
    return ret_mat;
  }

  ret_mat.n = m1->n;
  ret_mat.m = m2->m;

  for (i=0;i<ret_mat.n;i++)  {
    for (j=0;j<ret_mat.m;j++) ret_mat.a[i][j]=0.0;
  }

  for (i=0;i<ret_mat.n;i++){
    for (j=0;j<ret_mat.m;j++){
      for (k=0;k<mcount;k++){
	ret_mat.a[i][j] += m1->a[i][k] * m2->a[k][j] ;
      }
    }
  }
  return ret_mat;
}

int transpose(matrix *dest, matrix *src)
  /*--- ]us߂ */
{
  int i, j;

  dest->err = 0;
  if ((src->n>MAXN)||(src->n<0)) dest->err = 1;
  if ((src->m>MAXN)||(src->m<0)) dest->err = 1;
  if (dest->err == 1) {
    strcpy(dest->message, "Define the size of your matrix, stupid.");
    return 0 ;
  }
  strcpy(dest->message,"Done.");
  dest->n = src->m;
  dest->m = src->n;
  for (i=0;i<src->n;i++) {
    for (j=0;j<src->m;j++) {
      dest->a[j][i] = src->a[i][j];
    }
  }
  return 1 ;
}

double abs1(double x)
  /*--- Βl */
{
  if (x<0) return(-x);
  else return(x);
}

double nfunc(double x, double mk, double e)
{
  return(x - e * sin(x) - mk);        /*  Kepler's equation  */
}

double newton(double x0, double mk, double e)
  /*--- j[g@ */
{
  int i;
  double x1, fx0, dfdx0, aeps;
  double soln;
  int iterations, err;

  int imax=20;
  double eps=1e-13;

  err=1;
  aeps=x0 * eps / 10;

  for (i=0;i<imax;i++){
    fx0 = nfunc(x0, mk, e);
    dfdx0=(nfunc(x0+aeps, mk, e)-fx0)/aeps;
    x1=x0-fx0/dfdx0;
    if (abs1(x1-x0) < 10*aeps) {
      err=0;
      break;
    }
    x0=x1;
  }
  iterations=i+1;
  soln=x1;
  if(err) printf("Error: not convergence in newton()\n");
  return(soln);
}

void matdisp(matrix mm)
{
  int i,j;
  printf("(rows, columns) = (%d, %d)\n",mm.n, mm.m);
  for (i=0;i<mm.n;i++) {
    for (j=0;j<mm.m;j++) printf("%6.2f ",mm.a[i][j]);
    printf("\n");
  }
  printf("\n");
}
