#ifndef WII_JOYSTICK_H
#define WII_JOYSTICK_H

/*!
  \file
  \brief Wii WCXeBbN

  \author Satofumi KAMIMURA

  $Id$
*/

#include "JoystickInterface.h"
#include "GridTypes.h"
#include <memory>


/*!
  \brief Wii Rg[͂̎擾NX
*/
class WiiJoystick : public JoystickInterface {

  friend class mWiiJoystick;

  WiiJoystick(const WiiJoystick& rhs);
  WiiJoystick& operator = (const WiiJoystick& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

  void setRawAccelerations(Grid3D<unsigned char>& acc,
			   Grid3D<unsigned char>& acc_zero,
			   Grid3D<unsigned char>& acc_one);

public:
  enum {
    Button_A = 0,
    Button_B,
    Button_Minus,
    Button_Plus,
    Button_Home,
    Button_1,
    Button_2,
  };

  WiiJoystick(void);
  ~WiiJoystick(void);

  const char* what(void);

  bool connect(void);
  void disconnect(void);
  bool isConnected(void);

  const char* getProductInfo(void);
  size_t getNumAxis(void);
  size_t getNumButtons(void);
  short getAxisValue(size_t index);
  bool isButtonPressed(size_t index);
  void setEvent(SDL_Event& event);

  int getBatteryPercent(void);
  void setLed(unsigned char pattern);
  bool getRawAccelerations(Grid3D<unsigned char>& acc,
			   Grid3D<unsigned char>& acc_zero,
			   Grid3D<unsigned char>& acc_one);
  void getAccelerations(double* acceleration_x,
			double* acceleration_y,
			double* acceleration_z,
			double* roll = NULL, double* pitch = NULL);
  void accelerationCalibration(void);
};

#endif /* ! WII_JOYSTICK_H */
