/*!
  \file
  \brief f[^ X-Y ʓWJ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ConvertToGrid.h"
#include "RangeSensorInterface.h"
#include "MathUtils.h"


void convertToGrid(std::vector<Grid<int> >& points, long data[], size_t size,
		   const RangeSensorInterface& ranges) {

  long min_length = ranges.getMinDistance();
  long max_length = ranges.getMaxDistance();
  Grid<int> p;
  for (size_t i = 0; i < size; ++i) {
    long length = data[i];
    if ((length < min_length) || (length > max_length)) {
      continue;
    }
    // _̓o^
    double radian = ranges.index2rad(i);
    p.x = static_cast<int>(length * cos(radian));
    p.y = static_cast<int>(length * sin(radian));
    points.push_back(p);
  }
}
