/*!
  \file
  \brief SCIP nh

  \author Satofumi KAMIMURA

  $Id$

  \todo pImpl  isConnected() `ėp
*/

#include "ScipHandler.h"
#include "ConnectionInterface.h"
#include "SensorParameter.h"
#include "MathUtils.h"
#include "GetTicks.h"


/*!
  \brief ScipHandler ̓NX
*/
struct ScipHandler::pImpl {
  enum {
    Timeout = 130,
    //LineLength = 64 + 1 + 1 + 1,
    LineLength = 16 + 64 + 1 + 1 + 1, // 64 ȏ̃f[^ɑΏ

    RecvIncomplete = -1,
    PacketInvalid = -2,
  };

  std::string error_message;
  ConnectionInterface* con;
  SensorParameter params;
  size_t first, last;
  size_t data_byte;
  size_t groups;
  size_t skipFrames;
  size_t times;
  std::vector<long> recv_data;
  int remain_byte;
  char remain_data[3];
  int max_dataLength;
  bool laser_on;

  pImpl(void)
    : error_message("no error."), con(NULL),
      first(0), last(0), data_byte(2), groups(1), skipFrames(0), times(1),
      remain_byte(0), max_dataLength(0), laser_on(false) {
  }

  bool isLF(const char ch) {
    return ((ch == '\n') || (ch == '\r')) ? true : false;
  }

  long decode(const char* data, int data_byte) {
    long value = 0;
    for (int i = 0; i < data_byte; ++i) {
      value <<= 6;
      value &= ~0x3f;
      value |= data[i] - 0x30;
    }
    return value;
  }

  int readLine(char *buffer, int timeout = pImpl::Timeout) {
    if (con == NULL) {
      return 0;
    }

    int i;
    for (i = 0; i < LineLength -1; ++i) {
      char recv_ch;
      int n = con->recv(&recv_ch, 1, timeout);
      if (n <= 0) {
	if (i == 0) {
	  return -1;		// ^CAEg
	}
	break;
      }
      if (isLF(recv_ch)) {
	break;
      }
      buffer[i] = recv_ch;
    }

    buffer[i] = '\0';
    return i;
  }

  int sendTag(const char* tag) {
    if (! con) {
      return false;
    }

    char send_message[pImpl::LineLength];
    sprintf(send_message, "%s\n", tag);
    int send_size = strlen(send_message);
    int n = con->send(send_message, send_size);
    if (n < send_size) {
      // !!! error_message
      return -1;
    }
    return n;
  }

  int sendMessage(const char* tag, int timeout) {
    if (! con) {
      return -1;
    }

    // ݂̂Ԃ
    int send_size = sendTag(tag);
    int recv_size = send_size + 2 + 1 + 2;
    char buffer[LineLength];

    int n = con->recv(buffer, recv_size, timeout);
    if (n < recv_size) {
      // !!! error_message
      error_message = "XX 1";
      return RecvIncomplete;
    }

    // tag }b`邩mF
    if (strncmp(buffer, tag, send_size -1)) {
      // !!! error_message
      error_message = "XX 1.5";
      return PacketInvalid;
    }

    int data_length = recv_size - send_size;
    if (! checkSum(&buffer[send_size],
		   data_length - 3, buffer[send_size + data_length - 3])) {
      // !!! error_message
      error_message = "XX 2";
      return PacketInvalid;
    }

    // ̎擾
    char reply_str[3] = "00";
    reply_str[0] = buffer[send_size];
    reply_str[1] = buffer[send_size + 1];
    int reply = strtol(reply_str, NULL, 16);

    return reply;
  }

  bool checkSum(const char* buffer, size_t size, char expected) {

    char sum = 0;
    for (size_t i = 0; i < size; ++i) {
      sum += buffer[i];
    }
    sum = (sum & 0x3f) + 0x30;

    return (sum == expected) ? true : false;
  }

  int addRecvData(const char buffer[]) {

    const char* pre_p = buffer;
    const char* p = pre_p;

    if (remain_byte > 0) {
      memmove(&remain_data[remain_byte], buffer, data_byte - remain_byte);
      recv_data.push_back(decode(remain_data, data_byte));
      pre_p = &buffer[data_byte - remain_byte];
      p = pre_p;

      remain_byte = 0;
    }

    do {
      ++p;
      if ((p - pre_p) >= static_cast<int>(data_byte)) {
	recv_data.push_back(decode(pre_p, data_byte));
	pre_p = p;
      }
    } while (*p != '\0');
    remain_byte = p - pre_p;
    memmove(remain_data, pre_p, remain_byte);

    return 0;
  }

  void updateMaxDataLength(void) {
    max_dataLength = params.area_max +1;
  }

  void stopCapture(void) {
    sendMessage("QT", Timeout);
    laser_on = false;
  }
};


ScipHandler::ScipHandler(void) : pimpl(new pImpl) {
}


ScipHandler::~ScipHandler(void) {
}


const char* ScipHandler::what(void) {
  return pimpl->error_message.c_str();
}


void ScipHandler::setConnection(ConnectionInterface* con) {
  pimpl->con = con;
  //pimpl->con = new ConnectionLogger(con, true);
}


void ScipHandler::disconnect(void) {
  if (pimpl->con == NULL) {
    return;
  }

  // M̒~
  stopCapture();
  pimpl->con->disconnect();
}


bool ScipHandler::isConnected(void) const {

  return ((pimpl->con != NULL) && pimpl->con->isConnected()) ? true : false;
}


bool ScipHandler::adjustBaudrate(long baudrate) {

  // "SCIP2.0" p{[[g킹
  long try_baudrate[] = { 115200, 19200, 57600, };
  for (size_t i = 0; i < sizeof(try_baudrate)/sizeof(try_baudrate[0]); ++i) {
    int ret = pimpl->con->changeBaudrate(try_baudrate[i]);
    pimpl->con->skip(pImpl::Timeout);
    if (ret < 0) {
      pimpl->error_message = pimpl->con->what();
      return false;
    }

    // ̎擾R}h̒~
    stopCapture();

    // SCIP2.0 R}h𑗐MA'00'  '0E' ̉ŒʐMłƌȂ
    int reply = pimpl->sendMessage("SCIP2.0", pImpl::Timeout);
    if (reply < 0) {
      continue;
    }
    if ((reply == 0x00) || (reply == 0x0e)) {
      return setBaudrate(baudrate);
    }
  }

  pimpl->error_message = "Cannot adjust baudrate.";
  return false;
}


bool ScipHandler::setBaudrate(long baudrate) {

  // SS R}hɂ{[[gύX
  char buffer[] = "SS000000";
  sprintf(buffer, "SS%06ld", baudrate);
  int reply = pimpl->sendMessage(buffer, pImpl::Timeout);

  // Top-URG ւ̎bΉƂāA0xE ł true ԂĂ
  // Top-URG p SCIP2.0  SS T|[g΁A0xE ͍̏폜
  return ((reply == 0) || (reply == 3) || (reply == 0xE)) ? true : false;
}


bool ScipHandler::getVersionInfo(std::vector<std::string>& lines) {

  pimpl->sendTag("VV");
  char buffer[pImpl::LineLength];
  int line_length;
  for (int i = 0; (line_length = pimpl->readLine(buffer)) > 0; ++i) {

    enum {
      TagReply = 0,
      DataReply,
      Other,
    };
    if (i == TagReply) {
      // !!!
      // !!! false

    } else if (i == DataReply) {
      // !!!
      // !!! false

    } else if (i >= Other) {
      buffer[line_length -2] = '\0';
      lines.push_back(&buffer[5]);
    }
  }

  return true;
}


bool ScipHandler::loadSensorParameter(SensorParameter* parameter) {

  // p[^ǂݏoƔf
  pimpl->sendTag("PP");
  char buffer[pImpl::LineLength];
  int line_length;
  for (int i = 0; (line_length = pimpl->readLine(buffer)) > 0; ++i) {

    // `FbNT̊mF
    // !!!
    // !!! return false;

    enum {
      TagReply = 0,
      DataReply,
      Other,
    };
    if (i == TagReply) {
      // !!!
      // !!! return false;

    } else if (i == DataReply) {
      // !!!
      // !!! return false;

    } else if (i == Other + SensorParameter::MODL) {
      buffer[line_length - 2] = '\0';
      pimpl->params.model = &buffer[5];

    } else if (i == Other + SensorParameter::DMIN) {
      pimpl->params.distance_min = atoi(&buffer[5]);

    } else if (i == Other + SensorParameter::DMAX) {
      pimpl->params.distance_max = atoi(&buffer[5]);
      if (pimpl->params.distance_max > 4095) {
	pimpl->data_byte = 3;
      }
    } else if (i == Other + SensorParameter::ARES) {
      pimpl->params.area_total = atoi(&buffer[5]);

    } else if (i == Other + SensorParameter::AMIN) {
      pimpl->params.area_min = atoi(&buffer[5]);
      pimpl->first = pimpl->params.area_min;

    } else if (i == Other + SensorParameter::AMAX) {
      pimpl->params.area_max = atoi(&buffer[5]);
      pimpl->last = pimpl->params.area_max;

    } else if (i == Other + SensorParameter::AFRT) {
      pimpl->params.area_front = atoi(&buffer[5]);

    } else if (i == Other + SensorParameter::SCAN) {
      pimpl->params.scan_rpm = atoi(&buffer[5]);
    }
  }
  pimpl->updateMaxDataLength();

  if (parameter != NULL) {
    // ւ̃p[^
    *parameter = pimpl->params;
  }

  return true;
}


void ScipHandler::setSensorParameter(const SensorParameter* parameter) {
  pimpl->params = *parameter;
  pimpl->updateMaxDataLength();
}


void ScipHandler::setCaptureTimes(size_t times) {
  pimpl->times = times;
}


void ScipHandler::sendCaptureMessage(char cmd) {

  // !!! ̊֐ŁAQT ̑MKvłΑΏs

  // Timeout Ԃ́Ascan_rpm ̂P + 30 [msec] Ƃ
  // !!! pImpl ̃oƂĐ錾āAȂƂ銴ȁH

  pimpl->remain_byte = 0;

  char send_message[pImpl::LineLength];
  if (cmd == 'M') {
    sprintf(send_message, "M%c%04d%04d%02d%01d%02d",
	    (pimpl->data_byte == 2) ? 'S' : 'D',
	    pimpl->first, pimpl->last,
	    pimpl->groups, pimpl->skipFrames, pimpl->times);
  } else {
    sprintf(send_message, "G%c%04d%04d%02d",
	    (pimpl->data_byte == 2) ? 'S' : 'D',
	    pimpl->first, pimpl->last,
	    pimpl->groups);
  }
  // !!! ߂l̃`FbNׂBꉞ
  //int send_size = pimpl->sendTag(send_message);
  pimpl->sendTag(send_message);
}


int ScipHandler::recvCaptureData(long* data, size_t max_size,
				 size_t& timestamp) {
#if 0
  if (data == NULL) {
    return 0;
  }
#endif

  pimpl->recv_data.clear();

  // min ܂ł̗̈ 19(vL͈͊O)Ŗ߂
  for (int i = pimpl->params.area_min; i >= 0; --i) {
    pimpl->recv_data.push_back(19);
  }

  char message_type = 'M';
  char buffer[pImpl::LineLength];
  int line_length;
  size_t local_timestamp = 0;
  for (int i = 0; (line_length = pimpl->readLine(buffer)) >= 0; ++i) {

    //fprintf(stderr, "%02d: %s\n", i, buffer);

    // `FbNT̊mF
    // !!!
    // !!! return false;

    if ((i >= 6) && (line_length == 0)) {
      // f[^M̊
      int data_size = pimpl->recv_data.size();
      size_t min_length =
	(static_cast<int>(max_size) < data_size) ? max_size : data_size;
      for (size_t i = 0; i < min_length; ++i) {
	data[i] = pimpl->recv_data[i];
      }
      timestamp = local_timestamp;
      return min_length;

    } else if (i == 0) {
      // MbZ[W̍ŏ݂̂̕ŃbZ[W̔s
      if ((buffer[0] != 'M') && (buffer[0] != 'G')) {
	pimpl->error_message = "YY 01";
	//fprintf(stderr, "err 1\n");
	return pImpl::PacketInvalid;
      }
      message_type = buffer[0];

    } else if (! strncmp(buffer, "99b", 3)) {
      // "99b" oAȍ~u^CX^vvuf[^vƂ݂Ȃ
      i = 4;

    } else if ((i == 1) && (message_type == 'G')) {
      i = 4;

      // !!! 'G' R}h̎c񐔂́AŎo
      if (0) {
	pimpl->laser_on = false;
      }

    } else if (i == 2) {
      // MpPbgɑ΂鉞
      // !!!
      // MIA[U[͒~
      if (0) {
	pimpl->laser_on = false;
      }

    } else if (i == 4) {
      // "99b" Œ
      if (strncmp(buffer, "99b", 3)) {
	pimpl->error_message = "YY 02";
	return pImpl::PacketInvalid;
      }

    } else if (i == 5) {
      // ^CX^v
      local_timestamp = pimpl->decode(buffer, 4);

    } else if (i >= 6) {
      // 擾f[^
      if (line_length > (64 + 1)) {
	// !!! Top-URG ̃oO 65 byte ȏ̃f[^ɑΏ
	line_length = (64 + 1);
      }
      buffer[line_length -1] = '\0';
      int ret = pimpl->addRecvData(buffer);
      if (ret < 0) {
	pimpl->error_message = "YY 03";
	// !!! G[bZ[W̍XV
	return ret;
      }
    }
  }
  return -1;
}


void ScipHandler::stopCapture(void) {
  pimpl->stopCapture();
  if (pimpl->con) {
    pimpl->con->skip(pImpl::Timeout);
  }
}


void ScipHandler::setFrameSkipFrames(size_t skip_frames) {
  if ((skip_frames >= 0) && (skip_frames <= 9)) {
    pimpl->skipFrames = skip_frames;
  }
}


void ScipHandler::setDataGroups(size_t groups) {
  if ((groups > 0) && (groups <= 99)) {
    pimpl->groups = groups;
  }
}


void ScipHandler::setCaptureRange(int first_index, int last_index) {
  if ((first_index >= 0) && (first_index <= pimpl->params.area_max)) {
    pimpl->first = first_index;
  }
  if ((last_index >= first_index) && (last_index <= pimpl->params.area_max)) {
    pimpl->last = last_index;
  }
}


long ScipHandler::getMinDistance(void) const {
  return (isConnected()) ? pimpl->params.distance_min : -1;
}


long ScipHandler::getMaxDistance(void) const {
  return (isConnected()) ? pimpl->params.distance_max : -1;
}


int ScipHandler::getMaxDataLength(void) const {

  if (! isConnected()) {
    // new long[0] ƃG[ɂȂ邽߁APԂ
    return 1;
  } else {
    return pimpl->max_dataLength;
  }
}


int ScipHandler::getScanRpm(void) {

  if (! isConnected()) {
    return -1;
  } else {
    return pimpl->params.scan_rpm;
  }
}


void ScipHandler::setLaserOutput(bool on) {
  if (pimpl->laser_on == on) {
    // ԂςȂꍇ́A߂
    return;
  }

  int reply = pimpl->sendMessage("BM", pImpl::Timeout);

  if (reply >= 0) {
    pimpl->laser_on = on;
  }
}


double ScipHandler::index2rad(const int index) {
  if (! isConnected()) {
    return -1.0;
  }
  return (index - pimpl->params.area_front)
    * 2.0*M_PI / pimpl->params.area_total;
}


int ScipHandler::rad2index(const double radian) {
  if (! isConnected()) {
    return -1;
  }

  int index =
    static_cast<int>((radian * pimpl->params.area_total) / (2.0*M_PI))
    + pimpl->params.area_front;

  if (index < 0) {
    index = 0;
  } else if (index > pimpl->max_dataLength) {
    index = pimpl->max_dataLength;
  }
  return index;
}


size_t ScipHandler::getImmediateTimestamp(int* estimated_delay) {

  // !!! Г̒ʐMxԂA肵 estimated_delay Ɋi[ĕԂ
  // !!!

  bool laser_state = pimpl->laser_on;

  //stopCapture();

  int reply = pimpl->sendMessage("TM0", pImpl::Timeout);
  pimpl->laser_on = false;
  //fprintf(stderr, "TM0: %d\n", reply);

  //size_t first_ticks = GetTicks();
  long last_timestamp = 0;
  //reply = pimpl->sendMessage("TM1", pImpl::Timeout);
  pimpl->sendTag("TM1");

  // !!! ȉAЂǂB̂Aƍ蒼
  //if (reply == 0) {
  if (1) {
    char buffer[pImpl::LineLength];

    int line_length = pimpl->readLine(buffer);
    //fprintf(stderr, "%d: %s\n", line_length, buffer);

    line_length = pimpl->readLine(buffer);
    //fprintf(stderr, "%d: %s\n", line_length, buffer);

    line_length = pimpl->readLine(buffer);
    //fprintf(stderr, "%d: %s\n", line_length, buffer);

    last_timestamp = pimpl->decode(buffer, 4);
    //fprintf(stderr, "last_timestamp: %d\n", last_timestamp);
    pimpl->readLine(buffer);
    //fprintf(stderr, "%d: %s\n", line_length, buffer);
  }

  size_t last_ticks = GetTicks();

  reply = pimpl->sendMessage("TM2", pImpl::Timeout);
  //fprintf(stderr, "TM2: %d\n", reply);

  size_t spent_ticks = GetTicks();

  setLaserOutput(laser_state);

  return last_timestamp + (spent_ticks - last_ticks);
}
