// -*- C++ -*-
/*!
 * @file  UrgDevice.cpp
 * @brief URG device component
 * $Date$
 *
 * $Id$
 */

#include "UrgDevice.h"

// Module specification
// <rtc-template block="module_spec">
static const char* urgdevice_spec[] =
  {
    "implementation_id", "UrgDevice",
    "type_name",         "UrgDevice",
    "description",       "URG device component",
    "version",           "0.0.1",
    "vendor",            "Satofumi KAMIMURA",
    "category",          "Sensor Handling",
    "activity_type",     "DataFlowComponent",
    "max_instance",      "10",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    "conf.default.devices", "ttyACM0,ttyACM1,ttyACM2",

    ""
  };
// </rtc-template>

UrgDevice::UrgDevice(RTC::Manager* manager)
  : RTC::DataFlowComponentBase(manager),
    // <rtc-template block="initializer">
    //m_inIn("in", m_in),
    m_outOut("out", m_out),
    
    // </rtc-template>
    m_urg(m_devices.c_str())
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  //registerInPort("in", m_inIn);
  
  // Set OutPort buffer
  registerOutPort("out", m_outOut);
  
  // Set service provider to Ports
  
  // Set service consumers to Ports
  
  // Set CORBA Service Ports
  
  // </rtc-template>

}

UrgDevice::~UrgDevice()
{
}


RTC::ReturnCode_t UrgDevice::onInitialize()
{
  // <rtc-template block="bind_config">
  // Bind variables and configuration variable
  bindParameter("devices", m_devices, "ttyACM0,ttyACM1,ttyACM2");
  
  // </rtc-template>
  return RTC::RTC_OK;
}



/*
RTC::ReturnCode_t UrgDevice::onFinalize()
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t UrgDevice::onStartup(RTC::UniqueId ec_id)
{
  m_urg.connect("/dev/ttyACM0");

  return RTC::RTC_OK;
}

RTC::ReturnCode_t UrgDevice::onShutdown(RTC::UniqueId ec_id)
{
  m_urg.disconnect();
  return RTC::RTC_OK;
}

RTC::ReturnCode_t UrgDevice::onActivated(RTC::UniqueId ec_id)
{
  m_urg.startCapture();
  return RTC::RTC_OK;
}

RTC::ReturnCode_t UrgDevice::onDeactivated(RTC::UniqueId ec_id)
{
  m_urg.stopCapture();
  return RTC::RTC_OK;
}


RTC::ReturnCode_t UrgDevice::onExecute(RTC::UniqueId ec_id)
{
  m_urg.updateData();
  if (m_urg.haveData()) {
    m_out.data = m_urg.sendData();
    m_outOut.write();
  }
  usleep(1000);
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t UrgDevice::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgDevice::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgDevice::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgDevice::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgDevice::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/



extern "C"
{
 
  void UrgDeviceInit(RTC::Manager* manager)
  {
    RTC::Properties profile(urgdevice_spec);
    manager->registerFactory(profile,
                             RTC::Create<UrgDevice>,
                             RTC::Delete<UrgDevice>);
  }
  
};


