#ifndef URG_DEVICE_CTRL_H
#define URG_DEVICE_CTRL_H

/*!
  \file
  \brief UrgCtrl  OpenRTM pbp[

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>

class UrgDeviceCtrl {
  UrgDeviceCtrl(void);
  UrgDeviceCtrl(const UrgDeviceCtrl& rhs);
  UrgDeviceCtrl& operator = (const UrgDeviceCtrl& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  UrgDeviceCtrl(const char* devices);
  ~UrgDeviceCtrl(void);
  const char* what(void);

  bool connect(const char* device, const char* serial = "");
  void disconnect(void);
  bool isConnected(void);

  void startCapture(void);
  void stopCapture(void);

  //void handleCommand(const char* command);
  void updateData(void);
  bool haveData(void);
  const char* sendData(void);
};

#endif /* !URG_DEVICE_CTRL_H */

