#ifndef URG_CTRL_H
#define URG_CTRL_H

/*!
  \file
  \brief URG 

  \author Satofumi KAMIMURA

  $Id$

  \todo ^CX^v܂AtimestampAdjust/ ɈړBRunCtrl ̎ł悢
*/

#include "RangeSensorInterface.h"
#include <memory>

class ConnectionInterface;
class SensorParameter;


/*!
  \brief SCIP2.0 Kiɂ URG 
*/
class UrgCtrl : public RangeSensorInterface {
  UrgCtrl(const UrgCtrl& rhs);
  UrgCtrl& operator = (const UrgCtrl& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  enum {
    DefaultBaudrate = 115200,	//!< ftHg{[[g

    VEND = 0,			//!< x_
    PROD,			//!< i
    FIRM,			//!< t@[EFAo[W
    PROT,			//!< vgRo[W
    SERI,			//!< ZTŗLVAԍ
  };

  /*!
    \brief f[^̎擾`
  */
  typedef enum {
    ManualCapture,		//!< 擾
    AutoCapture,		//!< 擾
  } CaptureMode;

  UrgCtrl(void);
  ~UrgCtrl(void);
  const char* what(void);

  /*!
    \brief ڑ

    ͂Ă̐ڑBȉ̃IvV͉\

    - --urg_port=<port> ... ڑ|[gw
    - --urg_baudrate=<port> ... ڑ{[[gw
    - --urg_handstand ... URG ̎擾f[^̔zuJnƏIŔ]

    \retval true ڑ
    \retval false ڑɎs
  */
  bool connect(int argc, char* argv[]);
  bool connect(const char* device, long baudrate = DefaultBaudrate);
  bool connect(ConnectionInterface* con);
  void disconnect(void);
  bool isConnected(void);

  /*!
    \brief o[W̕Ԃ

    \param lines [o] o[W̕

    \todo ڂLqB̗
  */
  bool getVersionInfo(std::vector<std::string>& lines);

  long getMinDistance(void) const;
  long getMaxDistance(void) const;
  int getMaxDataLength(void) const;

  /*!
    \brief f[^擾

    f[^擾sAobt@Ɋi[

    \param data [o] 擾f[^pobt@
    \param max_size [i] 擾f[^pobt@̍őTCY

    \return 擾f[^
    \retval < 0 擾s
  */
  int capture(long data[], size_t max_size);

  // pxϊ
  double index2rad(const int index) const;
  int rad2index(const double radian) const;

  /*!
    \brief ^CX^v̒

    getTimestamp() ŕԂ^CX^vɂāÃ\bh]uԂ̒lAset_value ̒lɂȂ悤ɐݒ肷

    \param set_value [i] ^CX^vl̐ݒl

    \todo 킩ɂ̂AȂƂB}Kv
  */
  void adjustTimestamp(int set_value = 0);

  /*!
    \brief PC Œ^CX^v̎擾

    \attention capture() łȂ΁A̒l͖
   */
  long getTimestamp(void);

  /*!
    \brief ZTp[^̎擾

    \todo 
  */
  bool loadSensorParameter(SensorParameter* parameter);

  /*!
    \brief ZTp[^̐ݒ

    \todo 
  */
  void setSensorParameter(const SensorParameter* parameter);

  /*!
    \brief 擾f[^𔽓]

    \param on [i] ]Ƃ true

    \todo 킩ɂB}悢

    \attention ^ʖڂɓmFĂȂ...BgɂĂ͖肩H
  */
  void setHandstand(bool on = true);

  /*!
    \brief 擾[h̐ݒ

    \param mode [i] 擾[hݒ (AutoCapture / ManualCapture)

    \code
UrgCtrl urg;
urg.setCaptureMode(UrgCtrl::AutoCapture);
    \endcode

    擾[h̏ڍׂ \ref compare_auto_manual_page QƂ̂ƁB
  */
  void setCaptureMode(CaptureMode mode);

  /*!
    \brief 擾obt@̐ݒ

    Ɋi[łobt@(f[^)ݒ

    \param size [i] obt@

    \todo TO}pĐ
  */
  void setMaxBufferNum(size_t size);

  // t[̊Ԉ
  void setFrameSkipFrames(size_t skip_frames);

  /*!
    \brief f[^܂Ƃ߂O[v

    \param [i] groups ܂Ƃ߂O[v

    \todo Ɛ
  */
  void setDataGroups(size_t groups);

  // 擾͈͂̎w
  void setCaptureRange(int first_index, int last_index);

  /*!
    \brief [Ȕo͐

    \param on [i] true ̂ƂA[Uo͂ ON
  */
  void setLaserOutput(bool on);

  /*!
    \brief f[^擾̊Jn
  */
  void startCaptures(void);

  /*!
    \brief f[^擾̊Jn
  */
  void stopCaptures(void);

  // O capture() ̃^CX^vԂ
  unsigned long getRawTimestamp(void);

  /*!
    \brief ̎Ԃ擾

    \return ̎
  */
  int getScanMsec(void);
};

#endif /* !URG_CTRL_H */
