#!/usr/bin/perl
#==========================================================================#
#  B.Forum Ver.1.01                                                      #
#  󥹥ȡ                                                          #
#  Encode = EUC                                                          #
#  Hiroaki,Sakuma( sakuma@beetas.org )                                   #
#  BEETAS.org( info@beetas.org )                                         #
#                                                                          #
# Υץꥱϥץ󥽡Ǥ.                          #
# ̵ǻѤ뤳ȤǤޤ.                                            #
# ʤ, ܺ٤ʻѾ/ǿˤĤƤϲȤ.           #
# http://www.beetas.org/                                                   #
#                                                                          #
# ------------------------------------------------------------------------ #
# Copyright 2001-2002 Hiroaki,Sakuma All Rights Reserved.                  #
# Copyright 2001-2002 BEETAS.org All Rights Reserved.                      #
#                                                                          #
#==========================================================================#
package Bforum::Installer;
$version = '1.01R-1';
$revision = '1.01.0003';
$rcfile = '.bforumrc';
#$rcfile = 'bforum.conf';

require 5.005;

# ̩ʸˡå
use strict;

# Ѥѿ
use vars qw($version $revision $rcfile);
use vars qw($pwd $code $jcode $convert $verbose $email);
use vars qw(@BackupFile @CreateDir @CopyDir @CopyFile @Permission);
use vars qw(%init %dir %ftp);

# Хåեեå
$| = 1;

# ɸ⥸塼
use File::Copy;
use File::Path;

# Хååפե
@BackupFile = (".bforumrc","B.Forum/.default","B.Forum/.htaccess","B.Forum/BF.bfa","B.Forum/BF.bfa.fileupload","B.Forum/BF.bfa.namazu","B.Forum/.language/en","B.Forum/.language/ja");

# ǥ쥯ȥ
@CreateDir = ("B.Forum","B.Forum/.cache","B.Forum/.PLUGIN");
# ԡǥ쥯ȥ
@CopyDir = ("auto","B.Forum/.language");
# ԡե
@CopyFile = (".bforumrc","bforum.cgi","jcode.pl","Bforum.pm","B.Forum/.default","B.Forum/.htaccess","B.Forum/BF.bfa","B.Forum/BF.bfa.fileupload","B.Forum/BF.bfa.namazu");
# ѡߥå
@Permission = ([0644,".bforumrc"],[0755,"bforum.cgi"],[0644,"Bforum.pm"],[0755,"auto/"],[0755,"auto/Bforum/"],[0644,<auto/Bforum/*>],[0777,"B.Forum/"],[0666,"B.Forum/BF.bfa"],[0644,"B.Forum/.default"],[0777,"B.Forum/.cache"],[0755,"B.Forum/.language/"],[0644,<B.Forum/.language/*>],[0644,"B.Forum/.PLUGIN"]);

&main;

sub main {

	&init;

	if ($ARGV[0] eq '-h' || $ARGV[0] eq '--help') { &help; }
	&check_japanese;
	&check_install;
	&install_dir;
	&backup(@BackupFile);
	&create_dir(@CreateDir);
	&copy_dir(@CopyDir);
	&copy_file(@CopyFile);
	&permission;
	&install_modules;
	&finish;

	exit(0);

}

sub init {

	## PWD
	use Cwd;
	$pwd = Cwd::cwd();

	printf ("pwd" . ('.' x (75 - 3 - length($pwd))) . " %s\n",$pwd);

	## codeǧ
	$code = $ENV{'LANGUAGE'} || $ENV{'LC_ALL'} || $ENV{'LC_MESSAGES'} || $ENV{'LANG'};
	$code =~ s/^.._..\.([a-z]*).*$/$1/;

	printf ("code" . ('.' x (75 - 4 - length($code || "NG"))) . " %s\n",($code || "NG"));

	## jcode.plǧ
	$jcode = $ENV{'JCODE'};

	printf ("jcode" . ('.' x (75 - 5 - length($jcode || "NG"))) . " %s\n",($jcode || "NG"));

	if ($ARGV[0] eq '-v' || $ARGV[0] eq '--verbose') { $verbose = 1; }

}

sub check_japanese {

	my ($tmp1);

	while (1) {
		$tmp1 = &print("ιԤɽƤޤ\nIf you can't read upper line, type to 'exit' please.","Y/(N)","N");
		if ($tmp1 =~ /[yY]/) {
			return;
		} elsif ($tmp1 =~ /[nN]/) {
			&error("Install B.Forum is abort");
			print &convert("See the our webpage for more details and news\n");
			print "\n";
			print "http://www.beetas.org/\n";
			exit(0);
		}
	}

}

sub check_install {

	my ($tmp1);

	while (1) {
		print &convert("Υץꥱϥץ󥽡Ǥ\n");
		print &convert("̵ǻѤ뤳ȤǤޤ\n");
		print &convert("ܺ٤ʻѾ/ǿˤĤƤϲȤ\n");
		print "http://www.beetas.org/\n";
		$tmp1 = &print("󥹥ȡ³Ԥޤ","Y/(N)","N");
		if ($tmp1 =~ /[yY]/) {
			print "\n";
			print &convert(" *** ҥ **************************************************** \n");
			print &convert(" * 󥹥ȡǤݤ'exit'ȥפƤ.       * \n");
			print &convert(" * ɤƤ⥤󥹥ȡǤʤݤϥݡȤޤǤϢ. * \n");
			print &convert(" * ޤեɥХå⤪ԤƤޤ.                       * \n");
			print &convert(" *************************************************************** \n");
			return;
		} elsif ($tmp1 =~ /[nN]/) {
			print &convert("B.ForumΥ󥹥ȡǤޤ\n");
			print &convert("ǿ䥵ݡȤϥ֥Ȥ\n");
			print "\n";
			print "http://www.beetas.org/\n";
			exit(0);
		}
	}

}

sub install_dir {

	my ($tmp1);

	while (1) {
		$tmp1 = &print("󥹥ȡΥǥ쥯ȥꤷƤ.",($tmp1 || $pwd . "/B.Forum"),($tmp1 || $pwd . "/B.Forum"));
		if ($tmp1) {
			&_path($tmp1);
			$dir{'install'} = $tmp1;
			if (!-d $tmp1) {
				if (&_create_dir($tmp1)) { return; }
			} elsif (! -r $tmp1 ||! -w $tmp1 ||! -x $tmp1) {
				&error("ѡߥåޤ.");
			} else {
				return;
			}
		}
	}

}

sub _create_dir {

	my ($tmp1);

	while (1) {
		$tmp1 = &print("ꤵ줿ǥ쥯ȥ꤬Ĥޤ. ޤ","(Y)/N","Y");
		if ($tmp1 =~ /[yY]/) {
			print &convert("ǥ쥯ȥƤޤ... $_[0]\n");
			mkpath ($_[0],undef,0777);
			return 1;
		} elsif ($tmp1 =~ /[nN]/) {
			return;
		}
	}

}

sub backup {

	if (!$verbose) { print &convert("ŤեХååפƤޤ...\n"); }
	foreach (@_) {
		if (-f "$dir{'install'}/$_") {
			if ($verbose) { print &convert("ŤեХååפƤޤ... $_ => $_.old\n"); }
			rename ("$dir{'install'}/$_","$dir{'install'}/$_.old");
		}
	}

}

sub create_dir {

	if (!$verbose) { print &convert("ǥ쥯ȥƤޤ...\n"); }
	foreach (@_) {
		if (!-d "$dir{'install'}/$_") {
			if ($verbose) { print &convert("ǥ쥯ȥƤޤ... $_\n"); }
			mkpath ("$dir{'install'}/$_") || &error("$_Ǥޤ. $!");
		}
	}

}

sub copy_dir {

	use File::Find;

	if (!$verbose) { print &convert("ǥ쥯ȥ򥳥ԡƤޤ...\n"); }
	find(sub {
		if (-f $_) {
			if (!-d "$dir{'install'}/$File::Find::dir") {
				if ($verbose) { print &convert("ǥ쥯ȥ򥳥ԡƤޤ... $File::Find::dir\n"); }
				mkpath("$dir{'install'}/$File::Find::dir") || &error("$File::Find::dirǤޤ. $!");
			}
			if ($verbose) { print &convert("ե򥳥ԡƤޤ... $File::Find::name\n"); }
			copy ("$pwd/$File::Find::name","$dir{'install'}/$File::Find::name") || &error("$File::Find::name򥳥ԡǤޤ. $!");
		}
	},@_);

}

sub copy_file {

	my ($tmp1);

	if (!$verbose) { print &convert("ե򥳥ԡƤޤ...\n"); }
	foreach (@_) {
		$tmp1 = $_;
		if ($verbose) { print &convert("ե򥳥ԡƤޤ... $_ => $dir{'install'}/$tmp1\n"); }
		copy ($_,"$dir{'install'}/$tmp1") || &error("ԡǤޤ. $!");
	}

}

sub permission {

	my ($tmp1,$tmp2);

	while(1) {
		$tmp1 = &print("֥Ф'root', '" . getlogin . "'¤ưޤ","Y/(N)","N");
		if ($tmp1 =~ /[yY]/) {

			# root or owner
			if (!$verbose) { print &convert("ѡߥåѹƤޤ...\n"); }
			foreach (@Permission) {
				$tmp2 = $_->[0] & 0700;
				if (chmod ($tmp2,"$dir{'install'}/$_->[1]")) {
					if ($verbose) { print &convert("ѡߥåѹƤޤ... $_->[1](" . sprintf("%lo",$tmp2) . ")\n"); }
				} else {
					&error("ѡߥåѹޤ... $_->[1](" . sprintf("%lo",$tmp2) . ")");
				}
			}
			return;

		} elsif ($tmp1 =~ /[nN]/) {

			# nobody or apache
			if (!$verbose) { print &convert("ѡߥåѹƤޤ...\n"); }
			foreach (@Permission) {
				$tmp2 = $_->[0];
				if (chmod ($tmp2,"$dir{'install'}/$_->[1]")) {
					if ($verbose) { print &convert("ѡߥåѹƤޤ... $_->[1](" . sprintf("%lo",$tmp2) . ")\n"); }
				} else {
					&error("ѡߥåѹޤ... $_->[1](" . sprintf("%lo",$tmp2) . ")");
				}
			}
			return;

		}
	}

}

sub install_modules {

	my ($tmp1,$tmp2,$tmp3);

	while(1) {
		$tmp1 = &print("Perl⥸塼Archive::TarCompress::Zlibͥåȥ饤󥹥ȡ뤷ޤ","(Y)/N","Y");
		if ($tmp1 =~ /[yY]/) {

			while (1) {

				use Sys::Hostname;
				$email = getlogin . '@' . (hostname() || "localhost.localdomain");

				&ftp;
				foreach ("Archive::Tar","Compress::Zlib") {
					mkpath("tmp",undef,0777);
					if ($tmp3 = &download($_)) {
						&install_perl_modules($tmp3);
					}
					rmtree("tmp",undef,undef);
				}

				return;

			}

		} elsif ($tmp1 =~ /[nN]/) {
			return;
		}
	}

}

sub ftp {

	my ($tmp1,$tmp2,$tmp3,$tmp4,$tmp5);

	use Socket;

	print &convert("HTTP(www.beetas.org)³Ƥޤ.\n");

	socket(HTTP,PF_INET,SOCK_STREAM,getprotobyname('tcp')) || (&error("åȤǤޤ. $!") && return);

	connect(HTTP,sockaddr_in(80,inet_aton("www.beetas.org"))) || (&error("HTTP(www.beetas.org)³Ǥޤ. $!") && return);

	send(HTTP,"GET /Installer/bforum-$revision HTTP/1.0\r\n",0);
	send(HTTP,"Host: www.beetas.org\r\n",0);
	send(HTTP,"UserAgent: B.ForumInstaller/$version($revision)\r\n",0);
	send(HTTP,"\r\n",0);

	print &convert("HTTP(www.beetas.org)ǡƤޤ.\n");

#	while (1) {
#		recv(HTTP,$tmp1,1024,0);
	while (read(HTTP,$tmp1,1024) > 0) {
		$tmp2 .= $tmp1;
		## NTǤϻȤʤ
#		if (!$tmp1) { last; }
	}

	close(HTTP);

	## إå򥫥å
	$tmp2 =~ s/^.*\n\n//;

	foreach $tmp3 (split("\n",$tmp2)) {
		chomp ($tmp3);
		if ($tmp3 =~ /^\s*#/o) { next; }
		($tmp3) = split (/#\s+/,$tmp3);
		($tmp3) = split (/\s+#/,$tmp3);
		if (!$tmp3) { next; }
		if ($tmp3 =~ /\s*([^\s]+?)\s+(.*?)\s*$/gio) { $ftp{$1} = $2; }

	}

}

sub download {

	my ($tmp1,$tmp2,$tmp3,$tmp4);
	my (@tmp5);

	if ($verbose) { print &convert("$ftp{$_[0]}ɤޤ...\n"); }

	if ($ftp{$_[0]} =~ /ftp:\/\/([^\/]*)(.*)\/(.*)$/) {

		$tmp3 = $2;
		$tmp4 = $3;

		use Socket;

		print &convert("FTP($1)³Ƥޤ.\n");

		socket(FTP,PF_INET,SOCK_STREAM,getprotobyname('tcp')) || (&error("åȤǤޤ. $!") && return);

		connect(FTP,sockaddr_in(21,inet_aton($1))) || (&error("FTP($1)³Ǥޤ. $!") && return);

		&ftp_command("");
		&ftp_command("USER anonymous");
		&ftp_command("PASS $email");
		&ftp_command("TYPE I");
		$tmp1 = &ftp_command("PASV");

		if ($tmp1 =~ /\(([0-9,]+)\)/) {

			@tmp5 = split(',',$1);

			socket(PASV,PF_INET,SOCK_STREAM,getprotobyname('tcp')) || (&error("åȤǤޤ. $!") && return);

			connect(PASV,sockaddr_in(($tmp5[4] * 256 + $tmp5[5]),inet_aton("$tmp5[0].$tmp5[1].$tmp5[2].$tmp5[3]"))) || &error("PASV³Ǥޤ. $!");

			if ($verbose) { print &convert($tmp5[4] * 256 + $tmp5[5] . "ݡȤ³Ƥޤ...\n"); }

			if ($verbose) { print &convert("$ftp{$_[0]}ɤޤ...\n"); }

			print &convert("FTP($tmp2)ǡƤޤ.\n");

			&ftp_command("RETR $tmp3/$tmp4");
			open (FILE,">tmp/$tmp4");
			binmode (FILE);
			foreach (<PASV>) {
				print FILE $_;
			}
			close (FILE);

			close (PASV);

		} else {

			&error("PASV⡼ɤѤǤޤ.");
			return;

		}

		&ftp_command("");
		&ftp_command("QUIT");

		return $tmp4;

	}

}

sub ftp_command {

	my ($tmp1);

	if ($verbose) { print &convert("FTP> $_[0]\n"); }

	send(FTP,"$_[0]\r\n",0);

	$tmp1 = <FTP>;
	print " *** $tmp1";

	return $tmp1;

}

sub install_perl_modules {

	my ($tmp1);

	chdir("$pwd/tmp/");

	if ($verbose) { print &convert("Ÿޤ...\n"); }
	&command("gunzip -c $_[0] | tar -xvf -");

	if ($tmp1 = &search_makefile("./")) {

		if ($tmp1 =~ /^(.*)\/(.*)$/) {

			chdir ("$pwd/tmp/$1/");

			if ($verbose) { print &convert("Makefileޤ...\n"); }
			&command("perl Makefile.PL PREFIX=\"$dir{'install'}\"");

			if ($verbose) { print &convert("ѥ뤷ޤ...\n"); }
			&command("make");

			if ($verbose) { print &convert("ƥȤޤ...\n"); }
			&command("make test");

			if ($verbose) { print &convert("󥹥ȡ뤷ޤ...\n"); }
#			&command("make install");
			&command("cp -fR ./blib/lib/* $dir{'install'}");
			&command("cp -fR ./blib/arch/* $dir{'install'}");
#			&copy_dir("blib/lib","blib/arch");

			chdir ("$pwd/tmp/");

		}

	} else {

		&error("Makefile.PLĤޤ. ʥ⥸塼Ǥ.");
		&error("󥹥ȡ򥹥åפޤ.");

	}

	chdir("$pwd/");

	return;

}

sub command {

	if ($verbose) { print &convert("$_[0]\n"); }
	open (CMD,"$_[0] |");
	foreach (<CMD>) {
		if ($verbose) { print &convert("> $_"); }
	}
	close (CMD);

	return;

}

sub search_makefile {

	my ($tmp1);
	my (@tmp2);

	foreach (<$_[0]/*>) {
		if (-d $_) { push (@tmp2,$_); }
		if (-f $_ && $_ =~ /\/Makefile.PL$/) { return($_); }
	}

	foreach (@tmp2) {
		$tmp1 = &search_makefile ($_);
		if ($tmp1) { return($tmp1) };
	}

	return;

}

sub finish {

	my ($tmp1);

	if (&print("󥹥ȡ뤬λޤɬREADME.EUCɤǲɤߤޤ","(Y)/N","Y") =~ /[yY]/) {
		foreach ("less","more") {
			if (system($_,"README.EUC") == 0) {
				$tmp1 = 1;
				last;
			}
		}
		if (!$tmp1) { &error("README.EUC򳫤ޤǤ"); }
	}
	print "\n";
	print &convert("B.Forum򥤥󥹥ȡĺ꤬Ȥޤ\n");
	print &convert("ǿ䥵ݡȤϥ֥Ȥ\n");
	print "\n";
	print "http://www.beetas.org/\n";

}

sub help {

	print "\n";
	print &convert("Ȥ\n");
	print "\n";
	print "\$ ./install.pl [-v][-h] [--verbose] [--help]\n";
	print "\n";
	print &convert("[ץ]\n");
	print &convert("   -v --verbose   ܺɽǼ¹\n");
	print &convert("   -h --help      Υåɽ\n");
	exit(0);

}


sub print {

	my ($tmp1,$tmp2);

	print &convert("\n$_[0] \[$_[1]\] ");
	$tmp1 = <STDIN>;
	chomp ($tmp1);
	if ($tmp1 =~ /(exit|quit)/) {
		print &error("B.ForumΥ󥹥ȡǤޤ");
		print &convert("ǿ䥵ݡȤϥ֥Ȥ\n");
		print "\n";
		print "http://www.beetas.org/\n";
		exit(1);
	}
	if (!$tmp1) {
		return $_[2];
	} else {
		return $tmp1;
	}

}

sub convert {

	if ($code ne 'euc' && $jcode) {

		if (!$init{'jcode'}) {
			$init{'jcode'} = 1;
			eval ("require \"$jcode\"");
			if ($@) { return $_[0]; }
		}

		$convert = $_[0];
		&jcode::convert(\$convert,$code,'euc','z');
		return $convert;

	} else {

		return $_[0];

	}

}

sub error {

	print &convert("\n *** $_[0] *** \n\n");
	return 1;

}


sub _path {

	## Macintoshк
	$_[0] =~ tr/\\:/\//s;

	if ($_[0] !~ /^(\/|~|\w\/|:)/) {
		$_[0] = Cwd::cwd() . "/" . $_[0];
		$_[0] =~ s/\/\.\//\//go;
		while ($_[0] =~ /[^\/]+\/\.\.\//o) {
			$_[0] =~ s/[^\/]+\/\.\.\///go;
		}
	}

	$_[0] =~ s/^(\w)\/\//$1:\//;

	return $_[0];

}

