/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.glossary.engine.regex.ui.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten 正規表現 (Regex) 用語集エンジンのためのメッセージ。
 *
 * リソースバンドル定義: [RegexGlossaryPluginMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class RegexGlossaryPluginMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * RegexGlossaryPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[RegexGlossaryPluginMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public RegexGlossaryPluginMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/glossary/engine/regex/ui/messages/RegexGlossaryPluginMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * RegexGlossaryPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[RegexGlossaryPluginMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public RegexGlossaryPluginMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/glossary/engine/regex/ui/messages/RegexGlossaryPluginMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * RegexGlossaryPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[RegexGlossaryPluginMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public RegexGlossaryPluginMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/glossary/engine/regex/ui/messages/RegexGlossaryPluginMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[RegexGlossaryPluginMessages], key[getDriver_ClassNotFoundException]
     *
     * [Failed to read the Regex glossary engine.] (en)<br>
     * [Regex 用語集エンジンの読み込みに失敗しました。] (ja)<br>
     *
     * @return key[getDriver_ClassNotFoundException]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetDriverClassNotFoundException() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to read the Regex glossary engine.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getDriver_ClassNotFoundException");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[RegexGlossaryPluginMessages], key[load_I001]
     *
     * [Regex Glossary Engine Plug-in: Load the glossary refreshingly.] (en)<br>
     * [Regex 用語集エンジン・プラグイン: 用語集をリフレッシュ・ロードします。] (ja)<br>
     *
     * @return key[load_I001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLoadI001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Regex Glossary Engine Plug-in: Load the glossary refreshingly.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("load_I001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[RegexGlossaryPluginMessages], key[getTsvDir_I001]
     *
     * [Set the directory where TSV is saved: {0}] (en)<br>
     * [TSV を格納するディレクトリーを確定しました。: {0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[getTsvDir_I001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTsvDirI001(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Set the directory where TSV is saved: {0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTsvDir_I001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[RegexGlossaryPluginMessages], key[getTsvDir_E001]
     *
     * [TSV data directory &quot;{0}&quot; does not exist.] (en)<br>
     * [TSV データ・ディレクトリー ''{0}'' は存在しません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[getTsvDir_E001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTsvDirE001(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "TSV data directory \"{0}\" does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTsvDir_E001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[RegexGlossaryPluginMessages], key[getTsvDir_E002]
     *
     * [TSV data directory &quot;{0}&quot; is actually not a directory.] (en)<br>
     * [TSV データ・ディレクトリー ''{0}'' は、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[getTsvDir_E002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTsvDirE002(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "TSV data directory \"{0}\" is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTsvDir_E002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[RegexGlossaryPluginMessages], key[getTsvDataPlugin_E001]
     *
     * [It was unable to get the extension point.] (en)<br>
     * [拡張ポイントを取得することができませんでした。] (ja)<br>
     *
     * @return key[getTsvDataPlugin_E001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTsvDataPluginE001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "It was unable to get the extension point.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTsvDataPlugin_E001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[RegexGlossaryPluginMessages], key[getTsvDataPlugin_E002]
     *
     * [It was unable to get the glossary engine plug-in from the extension point.] (en)<br>
     * [拡張ポイントから用語集エンジン・プラグインを取得することができませんでした。] (ja)<br>
     *
     * @return key[getTsvDataPlugin_E002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTsvDataPluginE002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "It was unable to get the glossary engine plug-in from the extension point.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTsvDataPlugin_E002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
